/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Specifies the configuration to use for the brokers.
 * </p>
 * */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationInfo.Builder, ConfigurationInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConfigurationInfo::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Long> REVISION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ConfigurationInfo::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Long revision;

    private ConfigurationInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.revision = builder.revision;
    }

    /**
     *
     * <p>
     * ARN of the configuration to use.
     * </p>
     * 
     * @return <p>
     *         ARN of the configuration to use.
     *         </p>
     */
    public String arn() {
        return arn;
    }

    /**
     *
     * <p>
     * The revision of the configuration to use.
     * </p>
     * 
     * @return <p>
     *         The revision of the configuration to use.
     *         </p>
     */
    public Long revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationInfo)) {
            return false;
        }
        ConfigurationInfo other = (ConfigurationInfo) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConfigurationInfo").add("Arn", arn()).add("Revision", revision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationInfo, T> g) {
        return obj -> g.apply((ConfigurationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationInfo> {
        /**
         *
         * <p>
         * ARN of the configuration to use.
         * </p>
         * 
         * @param arn
         *        <p>
         *        ARN of the configuration to use.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         *
         * <p>
         * The revision of the configuration to use.
         * </p>
         * 
         * @param revision
         *        <p>
         *        The revision of the configuration to use.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Long revision);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Long revision;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationInfo model) {
            arn(model.arn);
            revision(model.revision);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getRevision() {
            return revision;
        }

        @Override
        public final Builder revision(Long revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Long revision) {
            this.revision = revision;
        }

        @Override
        public ConfigurationInfo build() {
            return new ConfigurationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
