/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterResponse extends KafkaResponse implements
        ToCopyableBuilder<DescribeClusterResponse.Builder, DescribeClusterResponse> {
    private static final SdkField<ClusterInfo> CLUSTER_INFO_FIELD = SdkField.<ClusterInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeClusterResponse::clusterInfo)).setter(setter(Builder::clusterInfo))
            .constructor(ClusterInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_INFO_FIELD));

    private final ClusterInfo clusterInfo;

    private DescribeClusterResponse(BuilderImpl builder) {
        super(builder);
        this.clusterInfo = builder.clusterInfo;
    }

    /**
     *
     * <p>
     * The cluster information.
     * </p>
     * 
     * @return <p>
     *         The cluster information.
     *         </p>
     */
    public ClusterInfo clusterInfo() {
        return clusterInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterResponse)) {
            return false;
        }
        DescribeClusterResponse other = (DescribeClusterResponse) obj;
        return Objects.equals(clusterInfo(), other.clusterInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeClusterResponse").add("ClusterInfo", clusterInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterInfo":
            return Optional.ofNullable(clazz.cast(clusterInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterResponse, T> g) {
        return obj -> g.apply((DescribeClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterResponse> {
        /**
         *
         * <p>
         * The cluster information.
         * </p>
         * 
         * @param clusterInfo
         *        <p>
         *        The cluster information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterInfo(ClusterInfo clusterInfo);

        /**
         *
         * <p>
         * The cluster information.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link ClusterInfo.Builder} avoiding the need to create
         * one manually via {@link ClusterInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #clusterInfo(ClusterInfo)}.
         * 
         * @param clusterInfo
         *        a consumer that will call methods on {@link ClusterInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterInfo(ClusterInfo)
         */
        default Builder clusterInfo(Consumer<ClusterInfo.Builder> clusterInfo) {
            return clusterInfo(ClusterInfo.builder().applyMutation(clusterInfo).build());
        }
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private ClusterInfo clusterInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterResponse model) {
            super(model);
            clusterInfo(model.clusterInfo);
        }

        public final ClusterInfo.Builder getClusterInfo() {
            return clusterInfo != null ? clusterInfo.toBuilder() : null;
        }

        @Override
        public final Builder clusterInfo(ClusterInfo clusterInfo) {
            this.clusterInfo = clusterInfo;
            return this;
        }

        public final void setClusterInfo(ClusterInfo.BuilderImpl clusterInfo) {
            this.clusterInfo = clusterInfo != null ? clusterInfo.build() : null;
        }

        @Override
        public DescribeClusterResponse build() {
            return new DescribeClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
