/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBootstrapBrokersResponse extends KafkaResponse implements
        ToCopyableBuilder<GetBootstrapBrokersResponse.Builder, GetBootstrapBrokersResponse> {
    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerString)).setter(setter(Builder::bootstrapBrokerString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapBrokerString").build())
            .build();

    private static final SdkField<String> BOOTSTRAP_BROKER_STRING_TLS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBootstrapBrokersResponse::bootstrapBrokerStringTls))
            .setter(setter(Builder::bootstrapBrokerStringTls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapBrokerStringTls").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOTSTRAP_BROKER_STRING_FIELD,
            BOOTSTRAP_BROKER_STRING_TLS_FIELD));

    private final String bootstrapBrokerString;

    private final String bootstrapBrokerStringTls;

    private GetBootstrapBrokersResponse(BuilderImpl builder) {
        super(builder);
        this.bootstrapBrokerString = builder.bootstrapBrokerString;
        this.bootstrapBrokerStringTls = builder.bootstrapBrokerStringTls;
    }

    /**
     *
     * <p>
     * A string containing one or more hostname:port pairs.
     * </p>
     * 
     * @return <p>
     *         A string containing one or more hostname:port pairs.
     *         </p>
     */
    public String bootstrapBrokerString() {
        return bootstrapBrokerString;
    }

    /**
     *
     * <p>
     * A string containing one or more DNS names (or IP) and TLS port pairs.
     * </p>
     * 
     * @return <p>
     *         A string containing one or more DNS names (or IP) and TLS port pairs.
     *         </p>
     */
    public String bootstrapBrokerStringTls() {
        return bootstrapBrokerStringTls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerString());
        hashCode = 31 * hashCode + Objects.hashCode(bootstrapBrokerStringTls());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBootstrapBrokersResponse)) {
            return false;
        }
        GetBootstrapBrokersResponse other = (GetBootstrapBrokersResponse) obj;
        return Objects.equals(bootstrapBrokerString(), other.bootstrapBrokerString())
                && Objects.equals(bootstrapBrokerStringTls(), other.bootstrapBrokerStringTls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBootstrapBrokersResponse").add("BootstrapBrokerString", bootstrapBrokerString())
                .add("BootstrapBrokerStringTls", bootstrapBrokerStringTls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BootstrapBrokerString":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerString()));
        case "BootstrapBrokerStringTls":
            return Optional.ofNullable(clazz.cast(bootstrapBrokerStringTls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBootstrapBrokersResponse, T> g) {
        return obj -> g.apply((GetBootstrapBrokersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBootstrapBrokersResponse> {
        /**
         *
         * <p>
         * A string containing one or more hostname:port pairs.
         * </p>
         * 
         * @param bootstrapBrokerString
         *        <p>
         *        A string containing one or more hostname:port pairs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerString(String bootstrapBrokerString);

        /**
         *
         * <p>
         * A string containing one or more DNS names (or IP) and TLS port pairs.
         * </p>
         * 
         * @param bootstrapBrokerStringTls
         *        <p>
         *        A string containing one or more DNS names (or IP) and TLS port pairs.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bootstrapBrokerStringTls(String bootstrapBrokerStringTls);
    }

    static final class BuilderImpl extends KafkaResponse.BuilderImpl implements Builder {
        private String bootstrapBrokerString;

        private String bootstrapBrokerStringTls;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBootstrapBrokersResponse model) {
            super(model);
            bootstrapBrokerString(model.bootstrapBrokerString);
            bootstrapBrokerStringTls(model.bootstrapBrokerStringTls);
        }

        public final String getBootstrapBrokerString() {
            return bootstrapBrokerString;
        }

        @Override
        public final Builder bootstrapBrokerString(String bootstrapBrokerString) {
            this.bootstrapBrokerString = bootstrapBrokerString;
            return this;
        }

        public final void setBootstrapBrokerString(String bootstrapBrokerString) {
            this.bootstrapBrokerString = bootstrapBrokerString;
        }

        public final String getBootstrapBrokerStringTls() {
            return bootstrapBrokerStringTls;
        }

        @Override
        public final Builder bootstrapBrokerStringTls(String bootstrapBrokerStringTls) {
            this.bootstrapBrokerStringTls = bootstrapBrokerStringTls;
            return this;
        }

        public final void setBootstrapBrokerStringTls(String bootstrapBrokerStringTls) {
            this.bootstrapBrokerStringTls = bootstrapBrokerStringTls;
        }

        @Override
        public GetBootstrapBrokersResponse build() {
            return new GetBootstrapBrokersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
