/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * JMX and Node monitoring for the MSK cluster.
 * </p>
 * */
@Generated("software.amazon.awssdk:codegen")
public final class OpenMonitoring implements SdkPojo, Serializable, ToCopyableBuilder<OpenMonitoring.Builder, OpenMonitoring> {
    private static final SdkField<Prometheus> PROMETHEUS_FIELD = SdkField.<Prometheus> builder(MarshallingType.SDK_POJO)
            .getter(getter(OpenMonitoring::prometheus)).setter(setter(Builder::prometheus)).constructor(Prometheus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prometheus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMETHEUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Prometheus prometheus;

    private OpenMonitoring(BuilderImpl builder) {
        this.prometheus = builder.prometheus;
    }

    /**
     *
     * <p>
     * Prometheus settings.
     * </p>
     * 
     * @return <p>
     *         Prometheus settings.
     *         </p>
     */
    public Prometheus prometheus() {
        return prometheus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prometheus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenMonitoring)) {
            return false;
        }
        OpenMonitoring other = (OpenMonitoring) obj;
        return Objects.equals(prometheus(), other.prometheus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OpenMonitoring").add("Prometheus", prometheus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prometheus":
            return Optional.ofNullable(clazz.cast(prometheus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenMonitoring, T> g) {
        return obj -> g.apply((OpenMonitoring) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenMonitoring> {
        /**
         *
         * <p>
         * Prometheus settings.
         * </p>
         * 
         * @param prometheus
         *        <p>
         *        Prometheus settings.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prometheus(Prometheus prometheus);

        /**
         *
         * <p>
         * Prometheus settings.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link Prometheus.Builder} avoiding the need to create
         * one manually via {@link Prometheus#builder()}.
         *
         * When the {@link Consumer} completes, {@link Prometheus.Builder#build()} is called immediately and its result
         * is passed to {@link #prometheus(Prometheus)}.
         * 
         * @param prometheus
         *        a consumer that will call methods on {@link Prometheus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prometheus(Prometheus)
         */
        default Builder prometheus(Consumer<Prometheus.Builder> prometheus) {
            return prometheus(Prometheus.builder().applyMutation(prometheus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Prometheus prometheus;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenMonitoring model) {
            prometheus(model.prometheus);
        }

        public final Prometheus.Builder getPrometheus() {
            return prometheus != null ? prometheus.toBuilder() : null;
        }

        @Override
        public final Builder prometheus(Prometheus prometheus) {
            this.prometheus = prometheus;
            return this;
        }

        public final void setPrometheus(Prometheus.BuilderImpl prometheus) {
            this.prometheus = prometheus != null ? prometheus.build() : null;
        }

        @Override
        public OpenMonitoring build() {
            return new OpenMonitoring(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
