/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 *
 * <p>
 * Contains information about storage volumes attached to MSK broker nodes.
 * </p>
 * */
@Generated("software.amazon.awssdk:codegen")
public final class StorageInfo implements SdkPojo, Serializable, ToCopyableBuilder<StorageInfo.Builder, StorageInfo> {
    private static final SdkField<EBSStorageInfo> EBS_STORAGE_INFO_FIELD = SdkField
            .<EBSStorageInfo> builder(MarshallingType.SDK_POJO).getter(getter(StorageInfo::ebsStorageInfo))
            .setter(setter(Builder::ebsStorageInfo)).constructor(EBSStorageInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsStorageInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_STORAGE_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final EBSStorageInfo ebsStorageInfo;

    private StorageInfo(BuilderImpl builder) {
        this.ebsStorageInfo = builder.ebsStorageInfo;
    }

    /**
     *
     * <p>
     * EBS volume information.
     * </p>
     * 
     * @return <p>
     *         EBS volume information.
     *         </p>
     */
    public EBSStorageInfo ebsStorageInfo() {
        return ebsStorageInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsStorageInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageInfo)) {
            return false;
        }
        StorageInfo other = (StorageInfo) obj;
        return Objects.equals(ebsStorageInfo(), other.ebsStorageInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StorageInfo").add("EbsStorageInfo", ebsStorageInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsStorageInfo":
            return Optional.ofNullable(clazz.cast(ebsStorageInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageInfo, T> g) {
        return obj -> g.apply((StorageInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageInfo> {
        /**
         *
         * <p>
         * EBS volume information.
         * </p>
         * 
         * @param ebsStorageInfo
         *        <p>
         *        EBS volume information.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsStorageInfo(EBSStorageInfo ebsStorageInfo);

        /**
         *
         * <p>
         * EBS volume information.
         * </p>
         * 
         * This is a convenience that creates an instance of the {@link EBSStorageInfo.Builder} avoiding the need to
         * create one manually via {@link EBSStorageInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link EBSStorageInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #ebsStorageInfo(EBSStorageInfo)}.
         * 
         * @param ebsStorageInfo
         *        a consumer that will call methods on {@link EBSStorageInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsStorageInfo(EBSStorageInfo)
         */
        default Builder ebsStorageInfo(Consumer<EBSStorageInfo.Builder> ebsStorageInfo) {
            return ebsStorageInfo(EBSStorageInfo.builder().applyMutation(ebsStorageInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EBSStorageInfo ebsStorageInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageInfo model) {
            ebsStorageInfo(model.ebsStorageInfo);
        }

        public final EBSStorageInfo.Builder getEbsStorageInfo() {
            return ebsStorageInfo != null ? ebsStorageInfo.toBuilder() : null;
        }

        @Override
        public final Builder ebsStorageInfo(EBSStorageInfo ebsStorageInfo) {
            this.ebsStorageInfo = ebsStorageInfo;
            return this;
        }

        public final void setEbsStorageInfo(EBSStorageInfo.BuilderImpl ebsStorageInfo) {
            this.ebsStorageInfo = ebsStorageInfo != null ? ebsStorageInfo.build() : null;
        }

        @Override
        public StorageInfo build() {
            return new StorageInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
