/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.BrokerNodeInfo;
import software.amazon.awssdk.services.kafka.model.NodeType;
import software.amazon.awssdk.services.kafka.model.ZookeeperNodeInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeInfo> {
    private static final SdkField<String> ADDED_TO_CLUSTER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeInfo.getter(NodeInfo::addedToClusterTime)).setter(NodeInfo.setter(Builder::addedToClusterTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addedToClusterTime").build()}).build();
    private static final SdkField<BrokerNodeInfo> BROKER_NODE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NodeInfo.getter(NodeInfo::brokerNodeInfo)).setter(NodeInfo.setter(Builder::brokerNodeInfo)).constructor(BrokerNodeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeInfo").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeInfo.getter(NodeInfo::instanceType)).setter(NodeInfo.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> NODE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeInfo.getter(NodeInfo::nodeARN)).setter(NodeInfo.setter(Builder::nodeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeARN").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeInfo.getter(NodeInfo::nodeTypeAsString)).setter(NodeInfo.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeType").build()}).build();
    private static final SdkField<ZookeeperNodeInfo> ZOOKEEPER_NODE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NodeInfo.getter(NodeInfo::zookeeperNodeInfo)).setter(NodeInfo.setter(Builder::zookeeperNodeInfo)).constructor(ZookeeperNodeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperNodeInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDED_TO_CLUSTER_TIME_FIELD, BROKER_NODE_INFO_FIELD, INSTANCE_TYPE_FIELD, NODE_ARN_FIELD, NODE_TYPE_FIELD, ZOOKEEPER_NODE_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String addedToClusterTime;
    private final BrokerNodeInfo brokerNodeInfo;
    private final String instanceType;
    private final String nodeARN;
    private final String nodeType;
    private final ZookeeperNodeInfo zookeeperNodeInfo;

    private NodeInfo(BuilderImpl builder) {
        this.addedToClusterTime = builder.addedToClusterTime;
        this.brokerNodeInfo = builder.brokerNodeInfo;
        this.instanceType = builder.instanceType;
        this.nodeARN = builder.nodeARN;
        this.nodeType = builder.nodeType;
        this.zookeeperNodeInfo = builder.zookeeperNodeInfo;
    }

    public String addedToClusterTime() {
        return this.addedToClusterTime;
    }

    public BrokerNodeInfo brokerNodeInfo() {
        return this.brokerNodeInfo;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String nodeARN() {
        return this.nodeARN;
    }

    public NodeType nodeType() {
        return NodeType.fromValue(this.nodeType);
    }

    public String nodeTypeAsString() {
        return this.nodeType;
    }

    public ZookeeperNodeInfo zookeeperNodeInfo() {
        return this.zookeeperNodeInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addedToClusterTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerNodeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperNodeInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInfo)) {
            return false;
        }
        NodeInfo other = (NodeInfo)obj;
        return Objects.equals(this.addedToClusterTime(), other.addedToClusterTime()) && Objects.equals(this.brokerNodeInfo(), other.brokerNodeInfo()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.nodeARN(), other.nodeARN()) && Objects.equals(this.nodeTypeAsString(), other.nodeTypeAsString()) && Objects.equals(this.zookeeperNodeInfo(), other.zookeeperNodeInfo());
    }

    public String toString() {
        return ToString.builder((String)"NodeInfo").add("AddedToClusterTime", (Object)this.addedToClusterTime()).add("BrokerNodeInfo", (Object)this.brokerNodeInfo()).add("InstanceType", (Object)this.instanceType()).add("NodeARN", (Object)this.nodeARN()).add("NodeType", (Object)this.nodeTypeAsString()).add("ZookeeperNodeInfo", (Object)this.zookeeperNodeInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddedToClusterTime": {
                return Optional.ofNullable(clazz.cast(this.addedToClusterTime()));
            }
            case "BrokerNodeInfo": {
                return Optional.ofNullable(clazz.cast(this.brokerNodeInfo()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "NodeARN": {
                return Optional.ofNullable(clazz.cast(this.nodeARN()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeTypeAsString()));
            }
            case "ZookeeperNodeInfo": {
                return Optional.ofNullable(clazz.cast(this.zookeeperNodeInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeInfo, T> g) {
        return obj -> g.apply((NodeInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String addedToClusterTime;
        private BrokerNodeInfo brokerNodeInfo;
        private String instanceType;
        private String nodeARN;
        private String nodeType;
        private ZookeeperNodeInfo zookeeperNodeInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInfo model) {
            this.addedToClusterTime(model.addedToClusterTime);
            this.brokerNodeInfo(model.brokerNodeInfo);
            this.instanceType(model.instanceType);
            this.nodeARN(model.nodeARN);
            this.nodeType(model.nodeType);
            this.zookeeperNodeInfo(model.zookeeperNodeInfo);
        }

        public final String getAddedToClusterTime() {
            return this.addedToClusterTime;
        }

        @Override
        public final Builder addedToClusterTime(String addedToClusterTime) {
            this.addedToClusterTime = addedToClusterTime;
            return this;
        }

        public final void setAddedToClusterTime(String addedToClusterTime) {
            this.addedToClusterTime = addedToClusterTime;
        }

        public final BrokerNodeInfo.Builder getBrokerNodeInfo() {
            return this.brokerNodeInfo != null ? this.brokerNodeInfo.toBuilder() : null;
        }

        @Override
        public final Builder brokerNodeInfo(BrokerNodeInfo brokerNodeInfo) {
            this.brokerNodeInfo = brokerNodeInfo;
            return this;
        }

        public final void setBrokerNodeInfo(BrokerNodeInfo.BuilderImpl brokerNodeInfo) {
            this.brokerNodeInfo = brokerNodeInfo != null ? brokerNodeInfo.build() : null;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getNodeARN() {
            return this.nodeARN;
        }

        @Override
        public final Builder nodeARN(String nodeARN) {
            this.nodeARN = nodeARN;
            return this;
        }

        public final void setNodeARN(String nodeARN) {
            this.nodeARN = nodeARN;
        }

        public final String getNodeTypeAsString() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(NodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final ZookeeperNodeInfo.Builder getZookeeperNodeInfo() {
            return this.zookeeperNodeInfo != null ? this.zookeeperNodeInfo.toBuilder() : null;
        }

        @Override
        public final Builder zookeeperNodeInfo(ZookeeperNodeInfo zookeeperNodeInfo) {
            this.zookeeperNodeInfo = zookeeperNodeInfo;
            return this;
        }

        public final void setZookeeperNodeInfo(ZookeeperNodeInfo.BuilderImpl zookeeperNodeInfo) {
            this.zookeeperNodeInfo = zookeeperNodeInfo != null ? zookeeperNodeInfo.build() : null;
        }

        public NodeInfo build() {
            return new NodeInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeInfo> {
        public Builder addedToClusterTime(String var1);

        public Builder brokerNodeInfo(BrokerNodeInfo var1);

        default public Builder brokerNodeInfo(Consumer<BrokerNodeInfo.Builder> brokerNodeInfo) {
            return this.brokerNodeInfo((BrokerNodeInfo)((BrokerNodeInfo.Builder)BrokerNodeInfo.builder().applyMutation(brokerNodeInfo)).build());
        }

        public Builder instanceType(String var1);

        public Builder nodeARN(String var1);

        public Builder nodeType(String var1);

        public Builder nodeType(NodeType var1);

        public Builder zookeeperNodeInfo(ZookeeperNodeInfo var1);

        default public Builder zookeeperNodeInfo(Consumer<ZookeeperNodeInfo.Builder> zookeeperNodeInfo) {
            return this.zookeeperNodeInfo((ZookeeperNodeInfo)((ZookeeperNodeInfo.Builder)ZookeeperNodeInfo.builder().applyMutation(zookeeperNodeInfo)).build());
        }
    }
}

