/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.model.ListScramSecretsRequest;
import software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse;

public class ListScramSecretsIterable
implements SdkIterable<ListScramSecretsResponse> {
    private final KafkaClient client;
    private final ListScramSecretsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScramSecretsIterable(KafkaClient client, ListScramSecretsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListScramSecretsResponseFetcher();
    }

    public Iterator<ListScramSecretsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> secretArnList() {
        Function<ListScramSecretsResponse, Iterator> getIterator = response -> {
            if (response != null && response.secretArnList() != null) {
                return response.secretArnList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListScramSecretsResponseFetcher
    implements SyncPageFetcher<ListScramSecretsResponse> {
        private ListScramSecretsResponseFetcher() {
        }

        public boolean hasNextPage(ListScramSecretsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScramSecretsResponse nextPage(ListScramSecretsResponse previousPage) {
            if (previousPage == null) {
                return ListScramSecretsIterable.this.client.listScramSecrets(ListScramSecretsIterable.this.firstRequest);
            }
            return ListScramSecretsIterable.this.client.listScramSecrets((ListScramSecretsRequest)((Object)ListScramSecretsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

