/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.StreamNameListCopier;
import software.amazon.awssdk.services.kinesis.model.StreamSummary;
import software.amazon.awssdk.services.kinesis.model.StreamSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamsResponse
extends KinesisResponse
implements ToCopyableBuilder<Builder, ListStreamsResponse> {
    private static final SdkField<List<String>> STREAM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StreamNames").getter(ListStreamsResponse.getter(ListStreamsResponse::streamNames)).setter(ListStreamsResponse.setter(Builder::streamNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> HAS_MORE_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasMoreStreams").getter(ListStreamsResponse.getter(ListStreamsResponse::hasMoreStreams)).setter(ListStreamsResponse.setter(Builder::hasMoreStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasMoreStreams").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStreamsResponse.getter(ListStreamsResponse::nextToken)).setter(ListStreamsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<StreamSummary>> STREAM_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StreamSummaries").getter(ListStreamsResponse.getter(ListStreamsResponse::streamSummaries)).setter(ListStreamsResponse.setter(Builder::streamSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAMES_FIELD, HAS_MORE_STREAMS_FIELD, NEXT_TOKEN_FIELD, STREAM_SUMMARIES_FIELD));
    private final List<String> streamNames;
    private final Boolean hasMoreStreams;
    private final String nextToken;
    private final List<StreamSummary> streamSummaries;

    private ListStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.streamNames = builder.streamNames;
        this.hasMoreStreams = builder.hasMoreStreams;
        this.nextToken = builder.nextToken;
        this.streamSummaries = builder.streamSummaries;
    }

    public final boolean hasStreamNames() {
        return this.streamNames != null && !(this.streamNames instanceof SdkAutoConstructList);
    }

    public final List<String> streamNames() {
        return this.streamNames;
    }

    public final Boolean hasMoreStreams() {
        return this.hasMoreStreams;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStreamSummaries() {
        return this.streamSummaries != null && !(this.streamSummaries instanceof SdkAutoConstructList);
    }

    public final List<StreamSummary> streamSummaries() {
        return this.streamSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreamNames() ? this.streamNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreStreams());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreamSummaries() ? this.streamSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse)((Object)obj);
        return this.hasStreamNames() == other.hasStreamNames() && Objects.equals(this.streamNames(), other.streamNames()) && Objects.equals(this.hasMoreStreams(), other.hasMoreStreams()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasStreamSummaries() == other.hasStreamSummaries() && Objects.equals(this.streamSummaries(), other.streamSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListStreamsResponse").add("StreamNames", this.hasStreamNames() ? this.streamNames() : null).add("HasMoreStreams", (Object)this.hasMoreStreams()).add("NextToken", (Object)this.nextToken()).add("StreamSummaries", this.hasStreamSummaries() ? this.streamSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamNames": {
                return Optional.ofNullable(clazz.cast(this.streamNames()));
            }
            case "HasMoreStreams": {
                return Optional.ofNullable(clazz.cast(this.hasMoreStreams()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StreamSummaries": {
                return Optional.ofNullable(clazz.cast(this.streamSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamsResponse, T> g) {
        return obj -> g.apply((ListStreamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisResponse.BuilderImpl
    implements Builder {
        private List<String> streamNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean hasMoreStreams;
        private String nextToken;
        private List<StreamSummary> streamSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            super(model);
            this.streamNames(model.streamNames);
            this.hasMoreStreams(model.hasMoreStreams);
            this.nextToken(model.nextToken);
            this.streamSummaries(model.streamSummaries);
        }

        public final Collection<String> getStreamNames() {
            if (this.streamNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.streamNames;
        }

        public final void setStreamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
        }

        @Override
        public final Builder streamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamNames(String ... streamNames) {
            this.streamNames(Arrays.asList(streamNames));
            return this;
        }

        public final Boolean getHasMoreStreams() {
            return this.hasMoreStreams;
        }

        public final void setHasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
        }

        @Override
        public final Builder hasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StreamSummary.Builder> getStreamSummaries() {
            List<StreamSummary.Builder> result = StreamSummaryListCopier.copyToBuilder(this.streamSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamSummaries(Collection<StreamSummary.BuilderImpl> streamSummaries) {
            this.streamSummaries = StreamSummaryListCopier.copyFromBuilder(streamSummaries);
        }

        @Override
        public final Builder streamSummaries(Collection<StreamSummary> streamSummaries) {
            this.streamSummaries = StreamSummaryListCopier.copy(streamSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamSummaries(StreamSummary ... streamSummaries) {
            this.streamSummaries(Arrays.asList(streamSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamSummaries(Consumer<StreamSummary.Builder> ... streamSummaries) {
            this.streamSummaries(Stream.of(streamSummaries).map(c -> (StreamSummary)((StreamSummary.Builder)StreamSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamsResponse> {
        public Builder streamNames(Collection<String> var1);

        public Builder streamNames(String ... var1);

        public Builder hasMoreStreams(Boolean var1);

        public Builder nextToken(String var1);

        public Builder streamSummaries(Collection<StreamSummary> var1);

        public Builder streamSummaries(StreamSummary ... var1);

        public Builder streamSummaries(Consumer<StreamSummary.Builder> ... var1);
    }
}

