/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Record
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Record> {
    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SequenceNumber").getter(Record.getter(Record::sequenceNumber)).setter(Record.setter(Builder::sequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()}).build();
    private static final SdkField<Instant> APPROXIMATE_ARRIVAL_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ApproximateArrivalTimestamp").getter(Record.getter(Record::approximateArrivalTimestamp)).setter(Record.setter(Builder::approximateArrivalTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateArrivalTimestamp").build()}).build();
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Data").getter(Record.getter(Record::data)).setter(Record.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()}).build();
    private static final SdkField<String> PARTITION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartitionKey").getter(Record.getter(Record::partitionKey)).setter(Record.setter(Builder::partitionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKey").build()}).build();
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionType").getter(Record.getter(Record::encryptionTypeAsString)).setter(Record.setter(Builder::encryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_NUMBER_FIELD, APPROXIMATE_ARRIVAL_TIMESTAMP_FIELD, DATA_FIELD, PARTITION_KEY_FIELD, ENCRYPTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Record.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sequenceNumber;
    private final Instant approximateArrivalTimestamp;
    private final SdkBytes data;
    private final String partitionKey;
    private final String encryptionType;

    private Record(BuilderImpl builder) {
        this.sequenceNumber = builder.sequenceNumber;
        this.approximateArrivalTimestamp = builder.approximateArrivalTimestamp;
        this.data = builder.data;
        this.partitionKey = builder.partitionKey;
        this.encryptionType = builder.encryptionType;
    }

    public final String sequenceNumber() {
        return this.sequenceNumber;
    }

    public final Instant approximateArrivalTimestamp() {
        return this.approximateArrivalTimestamp;
    }

    public final SdkBytes data() {
        return this.data;
    }

    public final String partitionKey() {
        return this.partitionKey;
    }

    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(this.encryptionType);
    }

    public final String encryptionTypeAsString() {
        return this.encryptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateArrivalTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        return Objects.equals(this.sequenceNumber(), other.sequenceNumber()) && Objects.equals(this.approximateArrivalTimestamp(), other.approximateArrivalTimestamp()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.partitionKey(), other.partitionKey()) && Objects.equals(this.encryptionTypeAsString(), other.encryptionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Record").add("SequenceNumber", (Object)this.sequenceNumber()).add("ApproximateArrivalTimestamp", (Object)this.approximateArrivalTimestamp()).add("Data", (Object)this.data()).add("PartitionKey", (Object)this.partitionKey()).add("EncryptionType", (Object)this.encryptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
            case "ApproximateArrivalTimestamp": {
                return Optional.ofNullable(clazz.cast(this.approximateArrivalTimestamp()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "PartitionKey": {
                return Optional.ofNullable(clazz.cast(this.partitionKey()));
            }
            case "EncryptionType": {
                return Optional.ofNullable(clazz.cast(this.encryptionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SequenceNumber", SEQUENCE_NUMBER_FIELD);
        map.put("ApproximateArrivalTimestamp", APPROXIMATE_ARRIVAL_TIMESTAMP_FIELD);
        map.put("Data", DATA_FIELD);
        map.put("PartitionKey", PARTITION_KEY_FIELD);
        map.put("EncryptionType", ENCRYPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Record, T> g) {
        return obj -> g.apply((Record)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sequenceNumber;
        private Instant approximateArrivalTimestamp;
        private SdkBytes data;
        private String partitionKey;
        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            this.sequenceNumber(model.sequenceNumber);
            this.approximateArrivalTimestamp(model.approximateArrivalTimestamp);
            this.data(model.data);
            this.partitionKey(model.partitionKey);
            this.encryptionType(model.encryptionType);
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final Instant getApproximateArrivalTimestamp() {
            return this.approximateArrivalTimestamp;
        }

        public final void setApproximateArrivalTimestamp(Instant approximateArrivalTimestamp) {
            this.approximateArrivalTimestamp = approximateArrivalTimestamp;
        }

        @Override
        public final Builder approximateArrivalTimestamp(Instant approximateArrivalTimestamp) {
            this.approximateArrivalTimestamp = approximateArrivalTimestamp;
            return this;
        }

        public final ByteBuffer getData() {
            return this.data == null ? null : this.data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            this.data(data == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final String getEncryptionType() {
            return this.encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public Record build() {
            return new Record(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Record> {
        public Builder sequenceNumber(String var1);

        public Builder approximateArrivalTimestamp(Instant var1);

        public Builder data(SdkBytes var1);

        public Builder partitionKey(String var1);

        public Builder encryptionType(String var1);

        public Builder encryptionType(EncryptionType var1);
    }
}

