/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceRequest extends LakeFormationRequest implements
        ToCopyableBuilder<UpdateResourceRequest.Builder, UpdateResourceRequest> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateResourceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(UpdateResourceRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<Boolean> WITH_FEDERATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WithFederation").getter(getter(UpdateResourceRequest::withFederation))
            .setter(setter(Builder::withFederation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithFederation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            RESOURCE_ARN_FIELD, WITH_FEDERATION_FIELD));

    private final String roleArn;

    private final String resourceArn;

    private final Boolean withFederation;

    private UpdateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.resourceArn = builder.resourceArn;
        this.withFederation = builder.withFederation;
    }

    /**
     * <p>
     * The new role to use for the given resource registered in Lake Formation.
     * </p>
     * 
     * @return The new role to use for the given resource registered in Lake Formation.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The resource ARN.
     * </p>
     * 
     * @return The resource ARN.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Whether or not the resource is a federated resource.
     * </p>
     * 
     * @return Whether or not the resource is a federated resource.
     */
    public final Boolean withFederation() {
        return withFederation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(withFederation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceRequest)) {
            return false;
        }
        UpdateResourceRequest other = (UpdateResourceRequest) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(withFederation(), other.withFederation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourceRequest").add("RoleArn", roleArn()).add("ResourceArn", resourceArn())
                .add("WithFederation", withFederation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "WithFederation":
            return Optional.ofNullable(clazz.cast(withFederation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceRequest, T> g) {
        return obj -> g.apply((UpdateResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResourceRequest> {
        /**
         * <p>
         * The new role to use for the given resource registered in Lake Formation.
         * </p>
         * 
         * @param roleArn
         *        The new role to use for the given resource registered in Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The resource ARN.
         * </p>
         * 
         * @param resourceArn
         *        The resource ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Whether or not the resource is a federated resource.
         * </p>
         * 
         * @param withFederation
         *        Whether or not the resource is a federated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withFederation(Boolean withFederation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String roleArn;

        private String resourceArn;

        private Boolean withFederation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceRequest model) {
            super(model);
            roleArn(model.roleArn);
            resourceArn(model.resourceArn);
            withFederation(model.withFederation);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Boolean getWithFederation() {
            return withFederation;
        }

        public final void setWithFederation(Boolean withFederation) {
            this.withFederation = withFederation;
        }

        @Override
        public final Builder withFederation(Boolean withFederation) {
            this.withFederation = withFederation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceRequest build() {
            return new UpdateResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
