/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.DestinationConfig;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutFunctionEventInvokeConfigRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, PutFunctionEventInvokeConfigRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(PutFunctionEventInvokeConfigRequest.getter(PutFunctionEventInvokeConfigRequest::functionName)).setter(PutFunctionEventInvokeConfigRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Qualifier").getter(PutFunctionEventInvokeConfigRequest.getter(PutFunctionEventInvokeConfigRequest::qualifier)).setter(PutFunctionEventInvokeConfigRequest.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRetryAttempts").getter(PutFunctionEventInvokeConfigRequest.getter(PutFunctionEventInvokeConfigRequest::maximumRetryAttempts)).setter(PutFunctionEventInvokeConfigRequest.setter(Builder::maximumRetryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build()}).build();
    private static final SdkField<Integer> MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumEventAgeInSeconds").getter(PutFunctionEventInvokeConfigRequest.getter(PutFunctionEventInvokeConfigRequest::maximumEventAgeInSeconds)).setter(PutFunctionEventInvokeConfigRequest.setter(Builder::maximumEventAgeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEventAgeInSeconds").build()}).build();
    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationConfig").getter(PutFunctionEventInvokeConfigRequest.getter(PutFunctionEventInvokeConfigRequest::destinationConfig)).setter(PutFunctionEventInvokeConfigRequest.setter(Builder::destinationConfig)).constructor(DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, QUALIFIER_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD, DESTINATION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutFunctionEventInvokeConfigRequest.memberNameToFieldInitializer();
    private final String functionName;
    private final String qualifier;
    private final Integer maximumRetryAttempts;
    private final Integer maximumEventAgeInSeconds;
    private final DestinationConfig destinationConfig;

    private PutFunctionEventInvokeConfigRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.qualifier = builder.qualifier;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
        this.destinationConfig = builder.destinationConfig;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String qualifier() {
        return this.qualifier;
    }

    public final Integer maximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    public final Integer maximumEventAgeInSeconds() {
        return this.maximumEventAgeInSeconds;
    }

    public final DestinationConfig destinationConfig() {
        return this.destinationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumEventAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionEventInvokeConfigRequest)) {
            return false;
        }
        PutFunctionEventInvokeConfigRequest other = (PutFunctionEventInvokeConfigRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.maximumRetryAttempts(), other.maximumRetryAttempts()) && Objects.equals(this.maximumEventAgeInSeconds(), other.maximumEventAgeInSeconds()) && Objects.equals(this.destinationConfig(), other.destinationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"PutFunctionEventInvokeConfigRequest").add("FunctionName", (Object)this.functionName()).add("Qualifier", (Object)this.qualifier()).add("MaximumRetryAttempts", (Object)this.maximumRetryAttempts()).add("MaximumEventAgeInSeconds", (Object)this.maximumEventAgeInSeconds()).add("DestinationConfig", (Object)this.destinationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "MaximumRetryAttempts": {
                return Optional.ofNullable(clazz.cast(this.maximumRetryAttempts()));
            }
            case "MaximumEventAgeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumEventAgeInSeconds()));
            }
            case "DestinationConfig": {
                return Optional.ofNullable(clazz.cast(this.destinationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("Qualifier", QUALIFIER_FIELD);
        map.put("MaximumRetryAttempts", MAXIMUM_RETRY_ATTEMPTS_FIELD);
        map.put("MaximumEventAgeInSeconds", MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD);
        map.put("DestinationConfig", DESTINATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutFunctionEventInvokeConfigRequest, T> g) {
        return obj -> g.apply((PutFunctionEventInvokeConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String qualifier;
        private Integer maximumRetryAttempts;
        private Integer maximumEventAgeInSeconds;
        private DestinationConfig destinationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionEventInvokeConfigRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.qualifier(model.qualifier);
            this.maximumRetryAttempts(model.maximumRetryAttempts);
            this.maximumEventAgeInSeconds(model.maximumEventAgeInSeconds);
            this.destinationConfig(model.destinationConfig);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getMaximumEventAgeInSeconds() {
            return this.maximumEventAgeInSeconds;
        }

        public final void setMaximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
        }

        @Override
        public final Builder maximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return this.destinationConfig != null ? this.destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFunctionEventInvokeConfigRequest build() {
            return new PutFunctionEventInvokeConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutFunctionEventInvokeConfigRequest> {
        public Builder functionName(String var1);

        public Builder qualifier(String var1);

        public Builder maximumRetryAttempts(Integer var1);

        public Builder maximumEventAgeInSeconds(Integer var1);

        public Builder destinationConfig(DestinationConfig var1);

        default public Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return this.destinationConfig((DestinationConfig)((DestinationConfig.Builder)DestinationConfig.builder().applyMutation(destinationConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

