/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MessageSelectionStrategy {
    RANDOM("Random"),
    ORDERED("Ordered"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MessageSelectionStrategy> VALUE_MAP;
    private final String value;

    private MessageSelectionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageSelectionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageSelectionStrategy> knownValues() {
        EnumSet<MessageSelectionStrategy> knownValues = EnumSet.allOf(MessageSelectionStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MessageSelectionStrategy.class, MessageSelectionStrategy::toString);
    }
}

