/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSessionResponse extends LexRuntimeResponse implements
        ToCopyableBuilder<GetSessionResponse.Builder, GetSessionResponse> {
    private static final SdkField<List<IntentSummary>> RECENT_INTENT_SUMMARY_VIEW_FIELD = SdkField
            .<List<IntentSummary>> builder(MarshallingType.LIST)
            .getter(getter(GetSessionResponse::recentIntentSummaryView))
            .setter(setter(Builder::recentIntentSummaryView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recentIntentSummaryView").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetSessionResponse::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<DialogAction> DIALOG_ACTION_FIELD = SdkField.<DialogAction> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetSessionResponse::dialogAction)).setter(setter(Builder::dialogAction))
            .constructor(DialogAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RECENT_INTENT_SUMMARY_VIEW_FIELD, SESSION_ATTRIBUTES_FIELD, SESSION_ID_FIELD, DIALOG_ACTION_FIELD));

    private final List<IntentSummary> recentIntentSummaryView;

    private final Map<String, String> sessionAttributes;

    private final String sessionId;

    private final DialogAction dialogAction;

    private GetSessionResponse(BuilderImpl builder) {
        super(builder);
        this.recentIntentSummaryView = builder.recentIntentSummaryView;
        this.sessionAttributes = builder.sessionAttributes;
        this.sessionId = builder.sessionId;
        this.dialogAction = builder.dialogAction;
    }

    /**
     * Returns true if the RecentIntentSummaryView property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRecentIntentSummaryView() {
        return recentIntentSummaryView != null && !(recentIntentSummaryView instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of information about the intents used in the session. The array can contain a maximum of three
     * summaries. If more than three intents are used in the session, the <code>recentIntentSummaryView</code> operation
     * contains information about the last three intents used.
     * </p>
     * <p>
     * If you set the <code>checkpointLabelFilter</code> parameter in the request, the array contains only the intents
     * with the specified label.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecentIntentSummaryView()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of information about the intents used in the session. The array can contain a maximum of three
     *         summaries. If more than three intents are used in the session, the <code>recentIntentSummaryView</code>
     *         operation contains information about the last three intents used.</p>
     *         <p>
     *         If you set the <code>checkpointLabelFilter</code> parameter in the request, the array contains only the
     *         intents with the specified label.
     */
    public List<IntentSummary> recentIntentSummaryView() {
        return recentIntentSummaryView;
    }

    /**
     * Returns true if the SessionAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSessionAttributes() {
        return sessionAttributes != null && !(sessionAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map of key/value pairs representing the session-specific context information. It contains application information
     * passed between Amazon Lex and a client application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSessionAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Map of key/value pairs representing the session-specific context information. It contains application
     *         information passed between Amazon Lex and a client application.
     */
    public Map<String, String> sessionAttributes() {
        return sessionAttributes;
    }

    /**
     * <p>
     * A unique identifier for the session.
     * </p>
     * 
     * @return A unique identifier for the session.
     */
    public String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Describes the current state of the bot.
     * </p>
     * 
     * @return Describes the current state of the bot.
     */
    public DialogAction dialogAction() {
        return dialogAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recentIntentSummaryView());
        hashCode = 31 * hashCode + Objects.hashCode(sessionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(dialogAction());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponse)) {
            return false;
        }
        GetSessionResponse other = (GetSessionResponse) obj;
        return Objects.equals(recentIntentSummaryView(), other.recentIntentSummaryView())
                && Objects.equals(sessionAttributes(), other.sessionAttributes())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(dialogAction(), other.dialogAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSessionResponse").add("RecentIntentSummaryView", recentIntentSummaryView())
                .add("SessionAttributes", sessionAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SessionId", sessionId()).add("DialogAction", dialogAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recentIntentSummaryView":
            return Optional.ofNullable(clazz.cast(recentIntentSummaryView()));
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "dialogAction":
            return Optional.ofNullable(clazz.cast(dialogAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponse, T> g) {
        return obj -> g.apply((GetSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexRuntimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSessionResponse> {
        /**
         * <p>
         * An array of information about the intents used in the session. The array can contain a maximum of three
         * summaries. If more than three intents are used in the session, the <code>recentIntentSummaryView</code>
         * operation contains information about the last three intents used.
         * </p>
         * <p>
         * If you set the <code>checkpointLabelFilter</code> parameter in the request, the array contains only the
         * intents with the specified label.
         * </p>
         * 
         * @param recentIntentSummaryView
         *        An array of information about the intents used in the session. The array can contain a maximum of
         *        three summaries. If more than three intents are used in the session, the
         *        <code>recentIntentSummaryView</code> operation contains information about the last three intents
         *        used.</p>
         *        <p>
         *        If you set the <code>checkpointLabelFilter</code> parameter in the request, the array contains only
         *        the intents with the specified label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recentIntentSummaryView(Collection<IntentSummary> recentIntentSummaryView);

        /**
         * <p>
         * An array of information about the intents used in the session. The array can contain a maximum of three
         * summaries. If more than three intents are used in the session, the <code>recentIntentSummaryView</code>
         * operation contains information about the last three intents used.
         * </p>
         * <p>
         * If you set the <code>checkpointLabelFilter</code> parameter in the request, the array contains only the
         * intents with the specified label.
         * </p>
         * 
         * @param recentIntentSummaryView
         *        An array of information about the intents used in the session. The array can contain a maximum of
         *        three summaries. If more than three intents are used in the session, the
         *        <code>recentIntentSummaryView</code> operation contains information about the last three intents
         *        used.</p>
         *        <p>
         *        If you set the <code>checkpointLabelFilter</code> parameter in the request, the array contains only
         *        the intents with the specified label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recentIntentSummaryView(IntentSummary... recentIntentSummaryView);

        /**
         * <p>
         * An array of information about the intents used in the session. The array can contain a maximum of three
         * summaries. If more than three intents are used in the session, the <code>recentIntentSummaryView</code>
         * operation contains information about the last three intents used.
         * </p>
         * <p>
         * If you set the <code>checkpointLabelFilter</code> parameter in the request, the array contains only the
         * intents with the specified label.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IntentSummary>.Builder} avoiding the need
         * to create one manually via {@link List<IntentSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IntentSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #recentIntentSummaryView(List<IntentSummary>)}.
         * 
         * @param recentIntentSummaryView
         *        a consumer that will call methods on {@link List<IntentSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recentIntentSummaryView(List<IntentSummary>)
         */
        Builder recentIntentSummaryView(Consumer<IntentSummary.Builder>... recentIntentSummaryView);

        /**
         * <p>
         * Map of key/value pairs representing the session-specific context information. It contains application
         * information passed between Amazon Lex and a client application.
         * </p>
         * 
         * @param sessionAttributes
         *        Map of key/value pairs representing the session-specific context information. It contains application
         *        information passed between Amazon Lex and a client application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(Map<String, String> sessionAttributes);

        /**
         * <p>
         * A unique identifier for the session.
         * </p>
         * 
         * @param sessionId
         *        A unique identifier for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Describes the current state of the bot.
         * </p>
         * 
         * @param dialogAction
         *        Describes the current state of the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogAction(DialogAction dialogAction);

        /**
         * <p>
         * Describes the current state of the bot.
         * </p>
         * This is a convenience that creates an instance of the {@link DialogAction.Builder} avoiding the need to
         * create one manually via {@link DialogAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link DialogAction.Builder#build()} is called immediately and its
         * result is passed to {@link #dialogAction(DialogAction)}.
         * 
         * @param dialogAction
         *        a consumer that will call methods on {@link DialogAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogAction(DialogAction)
         */
        default Builder dialogAction(Consumer<DialogAction.Builder> dialogAction) {
            return dialogAction(DialogAction.builder().applyMutation(dialogAction).build());
        }
    }

    static final class BuilderImpl extends LexRuntimeResponse.BuilderImpl implements Builder {
        private List<IntentSummary> recentIntentSummaryView = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String sessionId;

        private DialogAction dialogAction;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponse model) {
            super(model);
            recentIntentSummaryView(model.recentIntentSummaryView);
            sessionAttributes(model.sessionAttributes);
            sessionId(model.sessionId);
            dialogAction(model.dialogAction);
        }

        public final Collection<IntentSummary.Builder> getRecentIntentSummaryView() {
            return recentIntentSummaryView != null ? recentIntentSummaryView.stream().map(IntentSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recentIntentSummaryView(Collection<IntentSummary> recentIntentSummaryView) {
            this.recentIntentSummaryView = IntentSummaryListCopier.copy(recentIntentSummaryView);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recentIntentSummaryView(IntentSummary... recentIntentSummaryView) {
            recentIntentSummaryView(Arrays.asList(recentIntentSummaryView));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recentIntentSummaryView(Consumer<IntentSummary.Builder>... recentIntentSummaryView) {
            recentIntentSummaryView(Stream.of(recentIntentSummaryView).map(c -> IntentSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecentIntentSummaryView(Collection<IntentSummary.BuilderImpl> recentIntentSummaryView) {
            this.recentIntentSummaryView = IntentSummaryListCopier.copyFromBuilder(recentIntentSummaryView);
        }

        public final Map<String, String> getSessionAttributes() {
            return sessionAttributes;
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        public final String getSessionId() {
            return sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public final DialogAction.Builder getDialogAction() {
            return dialogAction != null ? dialogAction.toBuilder() : null;
        }

        @Override
        public final Builder dialogAction(DialogAction dialogAction) {
            this.dialogAction = dialogAction;
            return this;
        }

        public final void setDialogAction(DialogAction.BuilderImpl dialogAction) {
            this.dialogAction = dialogAction != null ? dialogAction.build() : null;
        }

        @Override
        public GetSessionResponse build() {
            return new GetSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
