/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLicenseManagerReportGeneratorRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<CreateLicenseManagerReportGeneratorRequest.Builder, CreateLicenseManagerReportGeneratorRequest> {
    private static final SdkField<String> REPORT_GENERATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportGeneratorName").getter(getter(CreateLicenseManagerReportGeneratorRequest::reportGeneratorName))
            .setter(setter(Builder::reportGeneratorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportGeneratorName").build())
            .build();

    private static final SdkField<List<String>> TYPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Type")
            .getter(getter(CreateLicenseManagerReportGeneratorRequest::typeAsStrings))
            .setter(setter(Builder::typeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ReportContext> REPORT_CONTEXT_FIELD = SdkField
            .<ReportContext> builder(MarshallingType.SDK_POJO).memberName("ReportContext")
            .getter(getter(CreateLicenseManagerReportGeneratorRequest::reportContext)).setter(setter(Builder::reportContext))
            .constructor(ReportContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportContext").build()).build();

    private static final SdkField<ReportFrequency> REPORT_FREQUENCY_FIELD = SdkField
            .<ReportFrequency> builder(MarshallingType.SDK_POJO).memberName("ReportFrequency")
            .getter(getter(CreateLicenseManagerReportGeneratorRequest::reportFrequency)).setter(setter(Builder::reportFrequency))
            .constructor(ReportFrequency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportFrequency").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreateLicenseManagerReportGeneratorRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateLicenseManagerReportGeneratorRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateLicenseManagerReportGeneratorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GENERATOR_NAME_FIELD,
            TYPE_FIELD, REPORT_CONTEXT_FIELD, REPORT_FREQUENCY_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private final String reportGeneratorName;

    private final List<String> type;

    private final ReportContext reportContext;

    private final ReportFrequency reportFrequency;

    private final String clientToken;

    private final String description;

    private final List<Tag> tags;

    private CreateLicenseManagerReportGeneratorRequest(BuilderImpl builder) {
        super(builder);
        this.reportGeneratorName = builder.reportGeneratorName;
        this.type = builder.type;
        this.reportContext = builder.reportContext;
        this.reportFrequency = builder.reportFrequency;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Name of the report generator.
     * </p>
     * 
     * @return Name of the report generator.
     */
    public final String reportGeneratorName() {
        return reportGeneratorName;
    }

    /**
     * <p>
     * Type of reports to generate. The following report types an be generated:
     * </p>
     * <ul>
     * <li>
     * <p>
     * License configuration report - Reports the number and details of consumed licenses for a license configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource report - Reports the tracked licenses and resource consumption for a license configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasType} method.
     * </p>
     * 
     * @return Type of reports to generate. The following report types an be generated:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         License configuration report - Reports the number and details of consumed licenses for a license
     *         configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Resource report - Reports the tracked licenses and resource consumption for a license configuration.
     *         </p>
     *         </li>
     */
    public final List<ReportType> type() {
        return ReportTypeListCopier.copyStringToEnum(type);
    }

    /**
     * For responses, this returns true if the service returned a value for the Type property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasType() {
        return type != null && !(type instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Type of reports to generate. The following report types an be generated:
     * </p>
     * <ul>
     * <li>
     * <p>
     * License configuration report - Reports the number and details of consumed licenses for a license configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource report - Reports the tracked licenses and resource consumption for a license configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasType} method.
     * </p>
     * 
     * @return Type of reports to generate. The following report types an be generated:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         License configuration report - Reports the number and details of consumed licenses for a license
     *         configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Resource report - Reports the tracked licenses and resource consumption for a license configuration.
     *         </p>
     *         </li>
     */
    public final List<String> typeAsStrings() {
        return type;
    }

    /**
     * <p>
     * Defines the type of license configuration the report generator tracks.
     * </p>
     * 
     * @return Defines the type of license configuration the report generator tracks.
     */
    public final ReportContext reportContext() {
        return reportContext;
    }

    /**
     * <p>
     * Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.
     * </p>
     * 
     * @return Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.
     */
    public final ReportFrequency reportFrequency() {
        return reportFrequency;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Description of the report generator.
     * </p>
     * 
     * @return Description of the report generator.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to add to the report generator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to add to the report generator.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportGeneratorName());
        hashCode = 31 * hashCode + Objects.hashCode(hasType() ? typeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reportContext());
        hashCode = 31 * hashCode + Objects.hashCode(reportFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseManagerReportGeneratorRequest)) {
            return false;
        }
        CreateLicenseManagerReportGeneratorRequest other = (CreateLicenseManagerReportGeneratorRequest) obj;
        return Objects.equals(reportGeneratorName(), other.reportGeneratorName()) && hasType() == other.hasType()
                && Objects.equals(typeAsStrings(), other.typeAsStrings())
                && Objects.equals(reportContext(), other.reportContext())
                && Objects.equals(reportFrequency(), other.reportFrequency())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLicenseManagerReportGeneratorRequest").add("ReportGeneratorName", reportGeneratorName())
                .add("Type", hasType() ? typeAsStrings() : null).add("ReportContext", reportContext())
                .add("ReportFrequency", reportFrequency()).add("ClientToken", clientToken()).add("Description", description())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportGeneratorName":
            return Optional.ofNullable(clazz.cast(reportGeneratorName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsStrings()));
        case "ReportContext":
            return Optional.ofNullable(clazz.cast(reportContext()));
        case "ReportFrequency":
            return Optional.ofNullable(clazz.cast(reportFrequency()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseManagerReportGeneratorRequest, T> g) {
        return obj -> g.apply((CreateLicenseManagerReportGeneratorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLicenseManagerReportGeneratorRequest> {
        /**
         * <p>
         * Name of the report generator.
         * </p>
         * 
         * @param reportGeneratorName
         *        Name of the report generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGeneratorName(String reportGeneratorName);

        /**
         * <p>
         * Type of reports to generate. The following report types an be generated:
         * </p>
         * <ul>
         * <li>
         * <p>
         * License configuration report - Reports the number and details of consumed licenses for a license
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * Resource report - Reports the tracked licenses and resource consumption for a license configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Type of reports to generate. The following report types an be generated:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        License configuration report - Reports the number and details of consumed licenses for a license
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resource report - Reports the tracked licenses and resource consumption for a license configuration.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeWithStrings(Collection<String> type);

        /**
         * <p>
         * Type of reports to generate. The following report types an be generated:
         * </p>
         * <ul>
         * <li>
         * <p>
         * License configuration report - Reports the number and details of consumed licenses for a license
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * Resource report - Reports the tracked licenses and resource consumption for a license configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Type of reports to generate. The following report types an be generated:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        License configuration report - Reports the number and details of consumed licenses for a license
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resource report - Reports the tracked licenses and resource consumption for a license configuration.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeWithStrings(String... type);

        /**
         * <p>
         * Type of reports to generate. The following report types an be generated:
         * </p>
         * <ul>
         * <li>
         * <p>
         * License configuration report - Reports the number and details of consumed licenses for a license
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * Resource report - Reports the tracked licenses and resource consumption for a license configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Type of reports to generate. The following report types an be generated:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        License configuration report - Reports the number and details of consumed licenses for a license
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resource report - Reports the tracked licenses and resource consumption for a license configuration.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Collection<ReportType> type);

        /**
         * <p>
         * Type of reports to generate. The following report types an be generated:
         * </p>
         * <ul>
         * <li>
         * <p>
         * License configuration report - Reports the number and details of consumed licenses for a license
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * Resource report - Reports the tracked licenses and resource consumption for a license configuration.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Type of reports to generate. The following report types an be generated:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        License configuration report - Reports the number and details of consumed licenses for a license
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resource report - Reports the tracked licenses and resource consumption for a license configuration.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(ReportType... type);

        /**
         * <p>
         * Defines the type of license configuration the report generator tracks.
         * </p>
         * 
         * @param reportContext
         *        Defines the type of license configuration the report generator tracks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportContext(ReportContext reportContext);

        /**
         * <p>
         * Defines the type of license configuration the report generator tracks.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportContext.Builder} avoiding the need
         * to create one manually via {@link ReportContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportContext.Builder#build()} is called immediately and its
         * result is passed to {@link #reportContext(ReportContext)}.
         * 
         * @param reportContext
         *        a consumer that will call methods on {@link ReportContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportContext(ReportContext)
         */
        default Builder reportContext(Consumer<ReportContext.Builder> reportContext) {
            return reportContext(ReportContext.builder().applyMutation(reportContext).build());
        }

        /**
         * <p>
         * Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.
         * </p>
         * 
         * @param reportFrequency
         *        Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportFrequency(ReportFrequency reportFrequency);

        /**
         * <p>
         * Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportFrequency.Builder} avoiding the
         * need to create one manually via {@link ReportFrequency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportFrequency.Builder#build()} is called immediately and its
         * result is passed to {@link #reportFrequency(ReportFrequency)}.
         * 
         * @param reportFrequency
         *        a consumer that will call methods on {@link ReportFrequency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportFrequency(ReportFrequency)
         */
        default Builder reportFrequency(Consumer<ReportFrequency.Builder> reportFrequency) {
            return reportFrequency(ReportFrequency.builder().applyMutation(reportFrequency).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Description of the report generator.
         * </p>
         * 
         * @param description
         *        Description of the report generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Tags to add to the report generator.
         * </p>
         * 
         * @param tags
         *        Tags to add to the report generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to add to the report generator.
         * </p>
         * 
         * @param tags
         *        Tags to add to the report generator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to add to the report generator.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.licensemanager.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.licensemanager.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.licensemanager.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.licensemanager.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private String reportGeneratorName;

        private List<String> type = DefaultSdkAutoConstructList.getInstance();

        private ReportContext reportContext;

        private ReportFrequency reportFrequency;

        private String clientToken;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseManagerReportGeneratorRequest model) {
            super(model);
            reportGeneratorName(model.reportGeneratorName);
            typeWithStrings(model.type);
            reportContext(model.reportContext);
            reportFrequency(model.reportFrequency);
            clientToken(model.clientToken);
            description(model.description);
            tags(model.tags);
        }

        public final String getReportGeneratorName() {
            return reportGeneratorName;
        }

        public final void setReportGeneratorName(String reportGeneratorName) {
            this.reportGeneratorName = reportGeneratorName;
        }

        @Override
        public final Builder reportGeneratorName(String reportGeneratorName) {
            this.reportGeneratorName = reportGeneratorName;
            return this;
        }

        public final Collection<String> getType() {
            if (type instanceof SdkAutoConstructList) {
                return null;
            }
            return type;
        }

        public final void setType(Collection<String> type) {
            this.type = ReportTypeListCopier.copy(type);
        }

        @Override
        public final Builder typeWithStrings(Collection<String> type) {
            this.type = ReportTypeListCopier.copy(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeWithStrings(String... type) {
            typeWithStrings(Arrays.asList(type));
            return this;
        }

        @Override
        public final Builder type(Collection<ReportType> type) {
            this.type = ReportTypeListCopier.copyEnumToString(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(ReportType... type) {
            type(Arrays.asList(type));
            return this;
        }

        public final ReportContext.Builder getReportContext() {
            return reportContext != null ? reportContext.toBuilder() : null;
        }

        public final void setReportContext(ReportContext.BuilderImpl reportContext) {
            this.reportContext = reportContext != null ? reportContext.build() : null;
        }

        @Override
        public final Builder reportContext(ReportContext reportContext) {
            this.reportContext = reportContext;
            return this;
        }

        public final ReportFrequency.Builder getReportFrequency() {
            return reportFrequency != null ? reportFrequency.toBuilder() : null;
        }

        public final void setReportFrequency(ReportFrequency.BuilderImpl reportFrequency) {
            this.reportFrequency = reportFrequency != null ? reportFrequency.build() : null;
        }

        @Override
        public final Builder reportFrequency(ReportFrequency reportFrequency) {
            this.reportFrequency = reportFrequency;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLicenseManagerReportGeneratorRequest build() {
            return new CreateLicenseManagerReportGeneratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
