/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies one or more data sets you want to import with the <a>CreateDataSetImportTask</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetImportConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetImportConfig.Builder, DataSetImportConfig> {
    private static final SdkField<List<DataSetImportItem>> DATA_SETS_FIELD = SdkField
            .<List<DataSetImportItem>> builder(MarshallingType.LIST)
            .memberName("dataSets")
            .getter(getter(DataSetImportConfig::dataSets))
            .setter(setter(Builder::dataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSetImportItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSetImportItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Location").getter(getter(DataSetImportConfig::s3Location)).setter(setter(Builder::s3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SETS_FIELD,
            S3_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DataSetImportItem> dataSets;

    private final String s3Location;

    private final Type type;

    private DataSetImportConfig(BuilderImpl builder) {
        this.dataSets = builder.dataSets;
        this.s3Location = builder.s3Location;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataSets() {
        return dataSets != null && !(dataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSets} method.
     * </p>
     * 
     * @return The data sets.
     */
    public final List<DataSetImportItem> dataSets() {
        return dataSets;
    }

    /**
     * <p>
     * The Amazon S3 location of the data sets.
     * </p>
     * 
     * @return The Amazon S3 location of the data sets.
     */
    public final String s3Location() {
        return s3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSets() ? dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetImportConfig)) {
            return false;
        }
        DataSetImportConfig other = (DataSetImportConfig) obj;
        return hasDataSets() == other.hasDataSets() && Objects.equals(dataSets(), other.dataSets())
                && Objects.equals(s3Location(), other.s3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetImportConfig").add("DataSets", hasDataSets() ? dataSets() : null)
                .add("S3Location", s3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSets":
            return Optional.ofNullable(clazz.cast(dataSets()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #dataSets()} initialized to the given value.
     *
     * <p>
     * The data sets.
     * </p>
     * 
     * @param dataSets
     *        The data sets.
     */
    public static DataSetImportConfig fromDataSets(List<DataSetImportItem> dataSets) {
        return builder().dataSets(dataSets).build();
    }

    /**
     * Create an instance of this class with {@link #s3Location()} initialized to the given value.
     *
     * <p>
     * The Amazon S3 location of the data sets.
     * </p>
     * 
     * @param s3Location
     *        The Amazon S3 location of the data sets.
     */
    public static DataSetImportConfig fromS3Location(String s3Location) {
        return builder().s3Location(s3Location).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetImportConfig, T> g) {
        return obj -> g.apply((DataSetImportConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetImportConfig> {
        /**
         * <p>
         * The data sets.
         * </p>
         * 
         * @param dataSets
         *        The data sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(Collection<DataSetImportItem> dataSets);

        /**
         * <p>
         * The data sets.
         * </p>
         * 
         * @param dataSets
         *        The data sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(DataSetImportItem... dataSets);

        /**
         * <p>
         * The data sets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.m2.model.DataSetImportItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.m2.model.DataSetImportItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.m2.model.DataSetImportItem.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSets(List<DataSetImportItem>)}.
         * 
         * @param dataSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.m2.model.DataSetImportItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSets(java.util.Collection<DataSetImportItem>)
         */
        Builder dataSets(Consumer<DataSetImportItem.Builder>... dataSets);

        /**
         * <p>
         * The Amazon S3 location of the data sets.
         * </p>
         * 
         * @param s3Location
         *        The Amazon S3 location of the data sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(String s3Location);
    }

    static final class BuilderImpl implements Builder {
        private List<DataSetImportItem> dataSets = DefaultSdkAutoConstructList.getInstance();

        private String s3Location;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetImportConfig model) {
            dataSets(model.dataSets);
            s3Location(model.s3Location);
        }

        public final List<DataSetImportItem.Builder> getDataSets() {
            List<DataSetImportItem.Builder> result = DataSetImportListCopier.copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<DataSetImportItem.BuilderImpl> dataSets) {
            Object oldValue = this.dataSets;
            this.dataSets = DataSetImportListCopier.copyFromBuilder(dataSets);
            handleUnionValueChange(Type.DATA_SETS, oldValue, this.dataSets);
        }

        @Override
        public final Builder dataSets(Collection<DataSetImportItem> dataSets) {
            Object oldValue = this.dataSets;
            this.dataSets = DataSetImportListCopier.copy(dataSets);
            handleUnionValueChange(Type.DATA_SETS, oldValue, this.dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(DataSetImportItem... dataSets) {
            dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<DataSetImportItem.Builder>... dataSets) {
            dataSets(Stream.of(dataSets).map(c -> DataSetImportItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getS3Location() {
            return s3Location;
        }

        public final void setS3Location(String s3Location) {
            Object oldValue = this.s3Location;
            this.s3Location = s3Location;
            handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
        }

        @Override
        public final Builder s3Location(String s3Location) {
            Object oldValue = this.s3Location;
            this.s3Location = s3Location;
            handleUnionValueChange(Type.S3_LOCATION, oldValue, this.s3Location);
            return this;
        }

        @Override
        public DataSetImportConfig build() {
            return new DataSetImportConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DataSetImportConfig#type()
     */
    public enum Type {
        DATA_SETS,

        S3_LOCATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
