/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a data set import task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSetImportTask implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSetImportTask.Builder, DataSetImportTask> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataSetImportTask::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<DataSetImportSummary> SUMMARY_FIELD = SdkField
            .<DataSetImportSummary> builder(MarshallingType.SDK_POJO).memberName("summary")
            .getter(getter(DataSetImportTask::summary)).setter(setter(Builder::summary))
            .constructor(DataSetImportSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(DataSetImportTask::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SUMMARY_FIELD,
            TASK_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final DataSetImportSummary summary;

    private final String taskId;

    private DataSetImportTask(BuilderImpl builder) {
        this.status = builder.status;
        this.summary = builder.summary;
        this.taskId = builder.taskId;
    }

    /**
     * <p>
     * The status of the data set import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSetTaskLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data set import task.
     * @see DataSetTaskLifecycle
     */
    public final DataSetTaskLifecycle status() {
        return DataSetTaskLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the data set import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSetTaskLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data set import task.
     * @see DataSetTaskLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A summary of the data set import task.
     * </p>
     * 
     * @return A summary of the data set import task.
     */
    public final DataSetImportSummary summary() {
        return summary;
    }

    /**
     * <p>
     * The identifier of the data set import task.
     * </p>
     * 
     * @return The identifier of the data set import task.
     */
    public final String taskId() {
        return taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetImportTask)) {
            return false;
        }
        DataSetImportTask other = (DataSetImportTask) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(summary(), other.summary())
                && Objects.equals(taskId(), other.taskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSetImportTask").add("Status", statusAsString()).add("Summary", summary())
                .add("TaskId", taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetImportTask, T> g) {
        return obj -> g.apply((DataSetImportTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSetImportTask> {
        /**
         * <p>
         * The status of the data set import task.
         * </p>
         * 
         * @param status
         *        The status of the data set import task.
         * @see DataSetTaskLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetTaskLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data set import task.
         * </p>
         * 
         * @param status
         *        The status of the data set import task.
         * @see DataSetTaskLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetTaskLifecycle
         */
        Builder status(DataSetTaskLifecycle status);

        /**
         * <p>
         * A summary of the data set import task.
         * </p>
         * 
         * @param summary
         *        A summary of the data set import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(DataSetImportSummary summary);

        /**
         * <p>
         * A summary of the data set import task.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSetImportSummary.Builder} avoiding
         * the need to create one manually via {@link DataSetImportSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSetImportSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #summary(DataSetImportSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link DataSetImportSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(DataSetImportSummary)
         */
        default Builder summary(Consumer<DataSetImportSummary.Builder> summary) {
            return summary(DataSetImportSummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * The identifier of the data set import task.
         * </p>
         * 
         * @param taskId
         *        The identifier of the data set import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private DataSetImportSummary summary;

        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetImportTask model) {
            status(model.status);
            summary(model.summary);
            taskId(model.taskId);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSetTaskLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DataSetImportSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(DataSetImportSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(DataSetImportSummary summary) {
            this.summary = summary;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public DataSetImportTask build() {
            return new DataSetImportTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
