/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.machinelearning.model.AddTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.AddTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRdsRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRdsResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromRedshiftResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Request;
import software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Response;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateMlModelResponse;
import software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointRequest;
import software.amazon.awssdk.services.machinelearning.model.CreateRealtimeEndpointResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteMlModelResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteRealtimeEndpointResponse;
import software.amazon.awssdk.services.machinelearning.model.DeleteTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.DeleteTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeTagsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse;
import software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.GetDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.GetEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.GetEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.GetMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.GetMlModelResponse;
import software.amazon.awssdk.services.machinelearning.model.PredictRequest;
import software.amazon.awssdk.services.machinelearning.model.PredictResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateEvaluationResponse;
import software.amazon.awssdk.services.machinelearning.model.UpdateMlModelRequest;
import software.amazon.awssdk.services.machinelearning.model.UpdateMlModelResponse;
import software.amazon.awssdk.services.machinelearning.paginators.DescribeBatchPredictionsPublisher;
import software.amazon.awssdk.services.machinelearning.paginators.DescribeDataSourcesPublisher;
import software.amazon.awssdk.services.machinelearning.paginators.DescribeEvaluationsPublisher;
import software.amazon.awssdk.services.machinelearning.paginators.DescribeMLModelsPublisher;
import software.amazon.awssdk.services.machinelearning.waiters.MachineLearningAsyncWaiter;

/**
 * Service client for accessing Amazon Machine Learning asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * Definition of the public APIs exposed by Amazon Machine Learning
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MachineLearningAsyncClient extends AwsClient {
    String SERVICE_NAME = "machinelearning";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "machinelearning";

    /**
     * <p>
     * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you
     * add a tag using a key that is already associated with the ML object, <code>AddTags</code> updates the tag's
     * value.
     * </p>
     *
     * @param addTagsRequest
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InvalidTagException</li>
     *         <li>TagLimitExceededException</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.AddTags
     */
    default CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you
     * add a tag using a key that is already associated with the ML object, <code>AddTags</code> updates the tag's
     * value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsInput.Builder} to create a request.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InvalidTagException</li>
     *         <li>TagLimitExceededException</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.AddTags
     */
    default CompletableFuture<AddTagsResponse> addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Generates predictions for a group of observations. The observations to process exist in one or more data files
     * referenced by a <code>DataSource</code>. This operation creates a new <code>BatchPrediction</code>, and uses an
     * <code>MLModel</code> and the data files referenced by the <code>DataSource</code> as information sources.
     * </p>
     * <p>
     * <code>CreateBatchPrediction</code> is an asynchronous operation. In response to
     * <code>CreateBatchPrediction</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>BatchPrediction</code> status to <code>PENDING</code>. After the <code>BatchPrediction</code> completes,
     * Amazon ML sets the status to <code>COMPLETED</code>.
     * </p>
     * <p>
     * You can poll for status updates by using the <a>GetBatchPrediction</a> operation and checking the
     * <code>Status</code> parameter of the result. After the <code>COMPLETED</code> status appears, the results are
     * available in the location specified by the <code>OutputUri</code> parameter.
     * </p>
     *
     * @param createBatchPredictionRequest
     * @return A Java Future containing the result of the CreateBatchPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateBatchPrediction
     */
    default CompletableFuture<CreateBatchPredictionResponse> createBatchPrediction(
            CreateBatchPredictionRequest createBatchPredictionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates predictions for a group of observations. The observations to process exist in one or more data files
     * referenced by a <code>DataSource</code>. This operation creates a new <code>BatchPrediction</code>, and uses an
     * <code>MLModel</code> and the data files referenced by the <code>DataSource</code> as information sources.
     * </p>
     * <p>
     * <code>CreateBatchPrediction</code> is an asynchronous operation. In response to
     * <code>CreateBatchPrediction</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>BatchPrediction</code> status to <code>PENDING</code>. After the <code>BatchPrediction</code> completes,
     * Amazon ML sets the status to <code>COMPLETED</code>.
     * </p>
     * <p>
     * You can poll for status updates by using the <a>GetBatchPrediction</a> operation and checking the
     * <code>Status</code> parameter of the result. After the <code>COMPLETED</code> status appears, the results are
     * available in the location specified by the <code>OutputUri</code> parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBatchPredictionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBatchPredictionRequest#builder()}
     * </p>
     *
     * @param createBatchPredictionRequest
     *        A {@link Consumer} that will call methods on {@link CreateBatchPredictionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBatchPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateBatchPrediction
     */
    default CompletableFuture<CreateBatchPredictionResponse> createBatchPrediction(
            Consumer<CreateBatchPredictionRequest.Builder> createBatchPredictionRequest) {
        return createBatchPrediction(CreateBatchPredictionRequest.builder().applyMutation(createBatchPredictionRequest).build());
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object from an <a href="http://aws.amazon.com/rds/"> Amazon Relational Database
     * Service</a> (Amazon RDS). A <code>DataSource</code> references data that can be used to perform
     * <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * <code>CreateDataSourceFromRDS</code> is an asynchronous operation. In response to
     * <code>CreateDataSourceFromRDS</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> is created and ready
     * for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in
     * the <code>COMPLETED</code> or <code>PENDING</code> state can be used only to perform
     * <code>&gt;CreateMLModel</code>&gt;, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code>
     * operations.
     * </p>
     * <p>
     * If Amazon ML cannot accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and
     * includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation
     * response.
     * </p>
     *
     * @param createDataSourceFromRdsRequest
     * @return A Java Future containing the result of the CreateDataSourceFromRDS operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateDataSourceFromRDS
     */
    default CompletableFuture<CreateDataSourceFromRdsResponse> createDataSourceFromRDS(
            CreateDataSourceFromRdsRequest createDataSourceFromRdsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object from an <a href="http://aws.amazon.com/rds/"> Amazon Relational Database
     * Service</a> (Amazon RDS). A <code>DataSource</code> references data that can be used to perform
     * <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * <code>CreateDataSourceFromRDS</code> is an asynchronous operation. In response to
     * <code>CreateDataSourceFromRDS</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> is created and ready
     * for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in
     * the <code>COMPLETED</code> or <code>PENDING</code> state can be used only to perform
     * <code>&gt;CreateMLModel</code>&gt;, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code>
     * operations.
     * </p>
     * <p>
     * If Amazon ML cannot accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and
     * includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation
     * response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceFromRdsRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDataSourceFromRdsRequest#builder()}
     * </p>
     *
     * @param createDataSourceFromRdsRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSourceFromRDSInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataSourceFromRDS operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateDataSourceFromRDS
     */
    default CompletableFuture<CreateDataSourceFromRdsResponse> createDataSourceFromRDS(
            Consumer<CreateDataSourceFromRdsRequest.Builder> createDataSourceFromRdsRequest) {
        return createDataSourceFromRDS(CreateDataSourceFromRdsRequest.builder().applyMutation(createDataSourceFromRdsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> from a database hosted on an Amazon Redshift cluster. A <code>DataSource</code>
     * references data that can be used to perform either <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or
     * <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * <code>CreateDataSourceFromRedshift</code> is an asynchronous operation. In response to
     * <code>CreateDataSourceFromRedshift</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> is created and ready
     * for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in
     * <code>COMPLETED</code> or <code>PENDING</code> states can be used to perform only <code>CreateMLModel</code>,
     * <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * If Amazon ML can't accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and
     * includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation
     * response.
     * </p>
     * <p>
     * The observations should be contained in the database hosted on an Amazon Redshift cluster and should be specified
     * by a <code>SelectSqlQuery</code> query. Amazon ML executes an <code>Unload</code> command in Amazon Redshift to
     * transfer the result set of the <code>SelectSqlQuery</code> query to <code>S3StagingLocation</code>.
     * </p>
     * <p>
     * After the <code>DataSource</code> has been created, it's ready for use in evaluations and batch predictions. If
     * you plan to use the <code>DataSource</code> to train an <code>MLModel</code>, the <code>DataSource</code> also
     * requires a recipe. A recipe describes how each input variable will be used in training an <code>MLModel</code>.
     * Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it
     * be combined with another variable or will it be split apart into word combinations? The recipe provides answers
     * to these questions.
     * </p>
     * <p>
     * You can't change an existing datasource, but you can copy and modify the settings from an existing Amazon
     * Redshift datasource to create a new datasource. To do so, call <code>GetDataSource</code> for an existing
     * datasource and copy the values to a <code>CreateDataSource</code> call. Change the settings that you want to
     * change and make sure that all required fields have the appropriate values.
     * </p>
     *
     * @param createDataSourceFromRedshiftRequest
     * @return A Java Future containing the result of the CreateDataSourceFromRedshift operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateDataSourceFromRedshift
     */
    default CompletableFuture<CreateDataSourceFromRedshiftResponse> createDataSourceFromRedshift(
            CreateDataSourceFromRedshiftRequest createDataSourceFromRedshiftRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> from a database hosted on an Amazon Redshift cluster. A <code>DataSource</code>
     * references data that can be used to perform either <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or
     * <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * <code>CreateDataSourceFromRedshift</code> is an asynchronous operation. In response to
     * <code>CreateDataSourceFromRedshift</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> is created and ready
     * for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in
     * <code>COMPLETED</code> or <code>PENDING</code> states can be used to perform only <code>CreateMLModel</code>,
     * <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * If Amazon ML can't accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and
     * includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation
     * response.
     * </p>
     * <p>
     * The observations should be contained in the database hosted on an Amazon Redshift cluster and should be specified
     * by a <code>SelectSqlQuery</code> query. Amazon ML executes an <code>Unload</code> command in Amazon Redshift to
     * transfer the result set of the <code>SelectSqlQuery</code> query to <code>S3StagingLocation</code>.
     * </p>
     * <p>
     * After the <code>DataSource</code> has been created, it's ready for use in evaluations and batch predictions. If
     * you plan to use the <code>DataSource</code> to train an <code>MLModel</code>, the <code>DataSource</code> also
     * requires a recipe. A recipe describes how each input variable will be used in training an <code>MLModel</code>.
     * Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it
     * be combined with another variable or will it be split apart into word combinations? The recipe provides answers
     * to these questions.
     * </p>
     * <p>
     * You can't change an existing datasource, but you can copy and modify the settings from an existing Amazon
     * Redshift datasource to create a new datasource. To do so, call <code>GetDataSource</code> for an existing
     * datasource and copy the values to a <code>CreateDataSource</code> call. Change the settings that you want to
     * change and make sure that all required fields have the appropriate values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceFromRedshiftRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDataSourceFromRedshiftRequest#builder()}
     * </p>
     *
     * @param createDataSourceFromRedshiftRequest
     *        A {@link Consumer} that will call methods on {@link CreateDataSourceFromRedshiftInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataSourceFromRedshift operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateDataSourceFromRedshift
     */
    default CompletableFuture<CreateDataSourceFromRedshiftResponse> createDataSourceFromRedshift(
            Consumer<CreateDataSourceFromRedshiftRequest.Builder> createDataSourceFromRedshiftRequest) {
        return createDataSourceFromRedshift(CreateDataSourceFromRedshiftRequest.builder()
                .applyMutation(createDataSourceFromRedshiftRequest).build());
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object. A <code>DataSource</code> references data that can be used to perform
     * <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * <code>CreateDataSourceFromS3</code> is an asynchronous operation. In response to
     * <code>CreateDataSourceFromS3</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> has been created and is
     * ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>.
     * <code>DataSource</code> in the <code>COMPLETED</code> or <code>PENDING</code> state can be used to perform only
     * <code>CreateMLModel</code>, <code>CreateEvaluation</code> or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * If Amazon ML can't accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and
     * includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation
     * response.
     * </p>
     * <p>
     * The observation data used in a <code>DataSource</code> should be ready to use; that is, it should have a
     * consistent structure, and missing data values should be kept to a minimum. The observation data must reside in
     * one or more .csv files in an Amazon Simple Storage Service (Amazon S3) location, along with a schema that
     * describes the data items by name and type. The same schema must be used for all of the data files referenced by
     * the <code>DataSource</code>.
     * </p>
     * <p>
     * After the <code>DataSource</code> has been created, it's ready to use in evaluations and batch predictions. If
     * you plan to use the <code>DataSource</code> to train an <code>MLModel</code>, the <code>DataSource</code> also
     * needs a recipe. A recipe describes how each input variable will be used in training an <code>MLModel</code>. Will
     * the variable be included or excluded from training? Will the variable be manipulated; for example, will it be
     * combined with another variable or will it be split apart into word combinations? The recipe provides answers to
     * these questions.
     * </p>
     *
     * @param createDataSourceFromS3Request
     * @return A Java Future containing the result of the CreateDataSourceFromS3 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateDataSourceFromS3
     */
    default CompletableFuture<CreateDataSourceFromS3Response> createDataSourceFromS3(
            CreateDataSourceFromS3Request createDataSourceFromS3Request) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object. A <code>DataSource</code> references data that can be used to perform
     * <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * <code>CreateDataSourceFromS3</code> is an asynchronous operation. In response to
     * <code>CreateDataSourceFromS3</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the
     * <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> has been created and is
     * ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>.
     * <code>DataSource</code> in the <code>COMPLETED</code> or <code>PENDING</code> state can be used to perform only
     * <code>CreateMLModel</code>, <code>CreateEvaluation</code> or <code>CreateBatchPrediction</code> operations.
     * </p>
     * <p>
     * If Amazon ML can't accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and
     * includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation
     * response.
     * </p>
     * <p>
     * The observation data used in a <code>DataSource</code> should be ready to use; that is, it should have a
     * consistent structure, and missing data values should be kept to a minimum. The observation data must reside in
     * one or more .csv files in an Amazon Simple Storage Service (Amazon S3) location, along with a schema that
     * describes the data items by name and type. The same schema must be used for all of the data files referenced by
     * the <code>DataSource</code>.
     * </p>
     * <p>
     * After the <code>DataSource</code> has been created, it's ready to use in evaluations and batch predictions. If
     * you plan to use the <code>DataSource</code> to train an <code>MLModel</code>, the <code>DataSource</code> also
     * needs a recipe. A recipe describes how each input variable will be used in training an <code>MLModel</code>. Will
     * the variable be included or excluded from training? Will the variable be manipulated; for example, will it be
     * combined with another variable or will it be split apart into word combinations? The recipe provides answers to
     * these questions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceFromS3Request.Builder} avoiding the
     * need to create one manually via {@link CreateDataSourceFromS3Request#builder()}
     * </p>
     *
     * @param createDataSourceFromS3Request
     *        A {@link Consumer} that will call methods on {@link CreateDataSourceFromS3Input.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDataSourceFromS3 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateDataSourceFromS3
     */
    default CompletableFuture<CreateDataSourceFromS3Response> createDataSourceFromS3(
            Consumer<CreateDataSourceFromS3Request.Builder> createDataSourceFromS3Request) {
        return createDataSourceFromS3(CreateDataSourceFromS3Request.builder().applyMutation(createDataSourceFromS3Request)
                .build());
    }

    /**
     * <p>
     * Creates a new <code>Evaluation</code> of an <code>MLModel</code>. An <code>MLModel</code> is evaluated on a set
     * of observations associated to a <code>DataSource</code>. Like a <code>DataSource</code> for an
     * <code>MLModel</code>, the <code>DataSource</code> for an <code>Evaluation</code> contains values for the
     * <code>Target Variable</code>. The <code>Evaluation</code> compares the predicted result for each observation to
     * the actual outcome and provides a summary so that you know how effective the <code>MLModel</code> functions on
     * the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or
     * MulticlassAvgFScore based on the corresponding <code>MLModelType</code>: <code>BINARY</code>,
     * <code>REGRESSION</code> or <code>MULTICLASS</code>.
     * </p>
     * <p>
     * <code>CreateEvaluation</code> is an asynchronous operation. In response to <code>CreateEvaluation</code>, Amazon
     * Machine Learning (Amazon ML) immediately returns and sets the evaluation status to <code>PENDING</code>. After
     * the <code>Evaluation</code> is created and ready for use, Amazon ML sets the status to <code>COMPLETED</code>.
     * </p>
     * <p>
     * You can use the <code>GetEvaluation</code> operation to check progress of the evaluation during the creation
     * operation.
     * </p>
     *
     * @param createEvaluationRequest
     * @return A Java Future containing the result of the CreateEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateEvaluation
     */
    default CompletableFuture<CreateEvaluationResponse> createEvaluation(CreateEvaluationRequest createEvaluationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new <code>Evaluation</code> of an <code>MLModel</code>. An <code>MLModel</code> is evaluated on a set
     * of observations associated to a <code>DataSource</code>. Like a <code>DataSource</code> for an
     * <code>MLModel</code>, the <code>DataSource</code> for an <code>Evaluation</code> contains values for the
     * <code>Target Variable</code>. The <code>Evaluation</code> compares the predicted result for each observation to
     * the actual outcome and provides a summary so that you know how effective the <code>MLModel</code> functions on
     * the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or
     * MulticlassAvgFScore based on the corresponding <code>MLModelType</code>: <code>BINARY</code>,
     * <code>REGRESSION</code> or <code>MULTICLASS</code>.
     * </p>
     * <p>
     * <code>CreateEvaluation</code> is an asynchronous operation. In response to <code>CreateEvaluation</code>, Amazon
     * Machine Learning (Amazon ML) immediately returns and sets the evaluation status to <code>PENDING</code>. After
     * the <code>Evaluation</code> is created and ready for use, Amazon ML sets the status to <code>COMPLETED</code>.
     * </p>
     * <p>
     * You can use the <code>GetEvaluation</code> operation to check progress of the evaluation during the creation
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEvaluationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEvaluationRequest#builder()}
     * </p>
     *
     * @param createEvaluationRequest
     *        A {@link Consumer} that will call methods on {@link CreateEvaluationInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateEvaluation
     */
    default CompletableFuture<CreateEvaluationResponse> createEvaluation(
            Consumer<CreateEvaluationRequest.Builder> createEvaluationRequest) {
        return createEvaluation(CreateEvaluationRequest.builder().applyMutation(createEvaluationRequest).build());
    }

    /**
     * <p>
     * Creates a new <code>MLModel</code> using the <code>DataSource</code> and the recipe as information sources.
     * </p>
     * <p>
     * An <code>MLModel</code> is nearly immutable. Users can update only the <code>MLModelName</code> and the
     * <code>ScoreThreshold</code> in an <code>MLModel</code> without creating a new <code>MLModel</code>.
     * </p>
     * <p>
     * <code>CreateMLModel</code> is an asynchronous operation. In response to <code>CreateMLModel</code>, Amazon
     * Machine Learning (Amazon ML) immediately returns and sets the <code>MLModel</code> status to <code>PENDING</code>
     * . After the <code>MLModel</code> has been created and ready is for use, Amazon ML sets the status to
     * <code>COMPLETED</code>.
     * </p>
     * <p>
     * You can use the <code>GetMLModel</code> operation to check the progress of the <code>MLModel</code> during the
     * creation operation.
     * </p>
     * <p>
     * <code>CreateMLModel</code> requires a <code>DataSource</code> with computed statistics, which can be created by
     * setting <code>ComputeStatistics</code> to <code>true</code> in <code>CreateDataSourceFromRDS</code>,
     * <code>CreateDataSourceFromS3</code>, or <code>CreateDataSourceFromRedshift</code> operations.
     * </p>
     *
     * @param createMlModelRequest
     * @return A Java Future containing the result of the CreateMLModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateMLModel
     */
    default CompletableFuture<CreateMlModelResponse> createMLModel(CreateMlModelRequest createMlModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new <code>MLModel</code> using the <code>DataSource</code> and the recipe as information sources.
     * </p>
     * <p>
     * An <code>MLModel</code> is nearly immutable. Users can update only the <code>MLModelName</code> and the
     * <code>ScoreThreshold</code> in an <code>MLModel</code> without creating a new <code>MLModel</code>.
     * </p>
     * <p>
     * <code>CreateMLModel</code> is an asynchronous operation. In response to <code>CreateMLModel</code>, Amazon
     * Machine Learning (Amazon ML) immediately returns and sets the <code>MLModel</code> status to <code>PENDING</code>
     * . After the <code>MLModel</code> has been created and ready is for use, Amazon ML sets the status to
     * <code>COMPLETED</code>.
     * </p>
     * <p>
     * You can use the <code>GetMLModel</code> operation to check the progress of the <code>MLModel</code> during the
     * creation operation.
     * </p>
     * <p>
     * <code>CreateMLModel</code> requires a <code>DataSource</code> with computed statistics, which can be created by
     * setting <code>ComputeStatistics</code> to <code>true</code> in <code>CreateDataSourceFromRDS</code>,
     * <code>CreateDataSourceFromS3</code>, or <code>CreateDataSourceFromRedshift</code> operations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMlModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMlModelRequest#builder()}
     * </p>
     *
     * @param createMlModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateMLModelInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMLModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>IdempotentParameterMismatchException A second request to use or change an object was not allowed.
     *         This can result from retrying a request using a parameter that was not present in the original request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateMLModel
     */
    default CompletableFuture<CreateMlModelResponse> createMLModel(Consumer<CreateMlModelRequest.Builder> createMlModelRequest) {
        return createMLModel(CreateMlModelRequest.builder().applyMutation(createMlModelRequest).build());
    }

    /**
     * <p>
     * Creates a real-time endpoint for the <code>MLModel</code>. The endpoint contains the URI of the
     * <code>MLModel</code>; that is, the location to send real-time prediction requests for the specified
     * <code>MLModel</code>.
     * </p>
     *
     * @param createRealtimeEndpointRequest
     * @return A Java Future containing the result of the CreateRealtimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateRealtimeEndpoint
     */
    default CompletableFuture<CreateRealtimeEndpointResponse> createRealtimeEndpoint(
            CreateRealtimeEndpointRequest createRealtimeEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a real-time endpoint for the <code>MLModel</code>. The endpoint contains the URI of the
     * <code>MLModel</code>; that is, the location to send real-time prediction requests for the specified
     * <code>MLModel</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRealtimeEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRealtimeEndpointRequest#builder()}
     * </p>
     *
     * @param createRealtimeEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateRealtimeEndpointInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRealtimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.CreateRealtimeEndpoint
     */
    default CompletableFuture<CreateRealtimeEndpointResponse> createRealtimeEndpoint(
            Consumer<CreateRealtimeEndpointRequest.Builder> createRealtimeEndpointRequest) {
        return createRealtimeEndpoint(CreateRealtimeEndpointRequest.builder().applyMutation(createRealtimeEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Assigns the DELETED status to a <code>BatchPrediction</code>, rendering it unusable.
     * </p>
     * <p>
     * After using the <code>DeleteBatchPrediction</code> operation, you can use the <a>GetBatchPrediction</a> operation
     * to verify that the status of the <code>BatchPrediction</code> changed to DELETED.
     * </p>
     * <p>
     * <b>Caution:</b> The result of the <code>DeleteBatchPrediction</code> operation is irreversible.
     * </p>
     *
     * @param deleteBatchPredictionRequest
     * @return A Java Future containing the result of the DeleteBatchPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteBatchPrediction
     */
    default CompletableFuture<DeleteBatchPredictionResponse> deleteBatchPrediction(
            DeleteBatchPredictionRequest deleteBatchPredictionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns the DELETED status to a <code>BatchPrediction</code>, rendering it unusable.
     * </p>
     * <p>
     * After using the <code>DeleteBatchPrediction</code> operation, you can use the <a>GetBatchPrediction</a> operation
     * to verify that the status of the <code>BatchPrediction</code> changed to DELETED.
     * </p>
     * <p>
     * <b>Caution:</b> The result of the <code>DeleteBatchPrediction</code> operation is irreversible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBatchPredictionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBatchPredictionRequest#builder()}
     * </p>
     *
     * @param deleteBatchPredictionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBatchPredictionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBatchPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteBatchPrediction
     */
    default CompletableFuture<DeleteBatchPredictionResponse> deleteBatchPrediction(
            Consumer<DeleteBatchPredictionRequest.Builder> deleteBatchPredictionRequest) {
        return deleteBatchPrediction(DeleteBatchPredictionRequest.builder().applyMutation(deleteBatchPredictionRequest).build());
    }

    /**
     * <p>
     * Assigns the DELETED status to a <code>DataSource</code>, rendering it unusable.
     * </p>
     * <p>
     * After using the <code>DeleteDataSource</code> operation, you can use the <a>GetDataSource</a> operation to verify
     * that the status of the <code>DataSource</code> changed to DELETED.
     * </p>
     * <p>
     * <b>Caution:</b> The results of the <code>DeleteDataSource</code> operation are irreversible.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteDataSource
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns the DELETED status to a <code>DataSource</code>, rendering it unusable.
     * </p>
     * <p>
     * After using the <code>DeleteDataSource</code> operation, you can use the <a>GetDataSource</a> operation to verify
     * that the status of the <code>DataSource</code> changed to DELETED.
     * </p>
     * <p>
     * <b>Caution:</b> The results of the <code>DeleteDataSource</code> operation are irreversible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDataSourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteDataSource
     */
    default CompletableFuture<DeleteDataSourceResponse> deleteDataSource(
            Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest) {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Assigns the <code>DELETED</code> status to an <code>Evaluation</code>, rendering it unusable.
     * </p>
     * <p>
     * After invoking the <code>DeleteEvaluation</code> operation, you can use the <code>GetEvaluation</code> operation
     * to verify that the status of the <code>Evaluation</code> changed to <code>DELETED</code>.
     * </p>
     * <p>
     * <b>Caution:</b> The results of the <code>DeleteEvaluation</code> operation are irreversible.
     * </p>
     *
     * @param deleteEvaluationRequest
     * @return A Java Future containing the result of the DeleteEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteEvaluation
     */
    default CompletableFuture<DeleteEvaluationResponse> deleteEvaluation(DeleteEvaluationRequest deleteEvaluationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns the <code>DELETED</code> status to an <code>Evaluation</code>, rendering it unusable.
     * </p>
     * <p>
     * After invoking the <code>DeleteEvaluation</code> operation, you can use the <code>GetEvaluation</code> operation
     * to verify that the status of the <code>Evaluation</code> changed to <code>DELETED</code>.
     * </p>
     * <p>
     * <b>Caution:</b> The results of the <code>DeleteEvaluation</code> operation are irreversible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEvaluationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEvaluationRequest#builder()}
     * </p>
     *
     * @param deleteEvaluationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEvaluationInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteEvaluation
     */
    default CompletableFuture<DeleteEvaluationResponse> deleteEvaluation(
            Consumer<DeleteEvaluationRequest.Builder> deleteEvaluationRequest) {
        return deleteEvaluation(DeleteEvaluationRequest.builder().applyMutation(deleteEvaluationRequest).build());
    }

    /**
     * <p>
     * Assigns the <code>DELETED</code> status to an <code>MLModel</code>, rendering it unusable.
     * </p>
     * <p>
     * After using the <code>DeleteMLModel</code> operation, you can use the <code>GetMLModel</code> operation to verify
     * that the status of the <code>MLModel</code> changed to DELETED.
     * </p>
     * <p>
     * <b>Caution:</b> The result of the <code>DeleteMLModel</code> operation is irreversible.
     * </p>
     *
     * @param deleteMlModelRequest
     * @return A Java Future containing the result of the DeleteMLModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteMLModel
     */
    default CompletableFuture<DeleteMlModelResponse> deleteMLModel(DeleteMlModelRequest deleteMlModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns the <code>DELETED</code> status to an <code>MLModel</code>, rendering it unusable.
     * </p>
     * <p>
     * After using the <code>DeleteMLModel</code> operation, you can use the <code>GetMLModel</code> operation to verify
     * that the status of the <code>MLModel</code> changed to DELETED.
     * </p>
     * <p>
     * <b>Caution:</b> The result of the <code>DeleteMLModel</code> operation is irreversible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMlModelRequest#builder()}
     * </p>
     *
     * @param deleteMlModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMLModelInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMLModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteMLModel
     */
    default CompletableFuture<DeleteMlModelResponse> deleteMLModel(Consumer<DeleteMlModelRequest.Builder> deleteMlModelRequest) {
        return deleteMLModel(DeleteMlModelRequest.builder().applyMutation(deleteMlModelRequest).build());
    }

    /**
     * <p>
     * Deletes a real time endpoint of an <code>MLModel</code>.
     * </p>
     *
     * @param deleteRealtimeEndpointRequest
     * @return A Java Future containing the result of the DeleteRealtimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteRealtimeEndpoint
     */
    default CompletableFuture<DeleteRealtimeEndpointResponse> deleteRealtimeEndpoint(
            DeleteRealtimeEndpointRequest deleteRealtimeEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a real time endpoint of an <code>MLModel</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRealtimeEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRealtimeEndpointRequest#builder()}
     * </p>
     *
     * @param deleteRealtimeEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRealtimeEndpointInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRealtimeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteRealtimeEndpoint
     */
    default CompletableFuture<DeleteRealtimeEndpointResponse> deleteRealtimeEndpoint(
            Consumer<DeleteRealtimeEndpointRequest.Builder> deleteRealtimeEndpointRequest) {
        return deleteRealtimeEndpoint(DeleteRealtimeEndpointRequest.builder().applyMutation(deleteRealtimeEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover
     * deleted tags.
     * </p>
     * <p>
     * If you specify a tag that doesn't exist, Amazon ML ignores it.
     * </p>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InvalidTagException</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteTags
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover
     * deleted tags.
     * </p>
     * <p>
     * If you specify a tag that doesn't exist, Amazon ML ignores it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InvalidTagException</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DeleteTags
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.
     * </p>
     *
     * @param describeBatchPredictionsRequest
     * @return A Java Future containing the result of the DescribeBatchPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeBatchPredictions
     */
    default CompletableFuture<DescribeBatchPredictionsResponse> describeBatchPredictions(
            DescribeBatchPredictionsRequest describeBatchPredictionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBatchPredictionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBatchPredictionsRequest#builder()}
     * </p>
     *
     * @param describeBatchPredictionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBatchPredictionsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBatchPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeBatchPredictions
     */
    default CompletableFuture<DescribeBatchPredictionsResponse> describeBatchPredictions(
            Consumer<DescribeBatchPredictionsRequest.Builder> describeBatchPredictionsRequest) {
        return describeBatchPredictions(DescribeBatchPredictionsRequest.builder().applyMutation(describeBatchPredictionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeBatchPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeBatchPredictions
     */
    default CompletableFuture<DescribeBatchPredictionsResponse> describeBatchPredictions() {
        return describeBatchPredictions(DescribeBatchPredictionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeBatchPredictions(software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeBatchPredictionsPublisher publisher = client.describeBatchPredictionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeBatchPredictionsPublisher publisher = client.describeBatchPredictionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBatchPredictions(software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeBatchPredictions
     */
    default DescribeBatchPredictionsPublisher describeBatchPredictionsPaginator() {
        return describeBatchPredictionsPaginator(DescribeBatchPredictionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeBatchPredictions(software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeBatchPredictionsPublisher publisher = client.describeBatchPredictionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeBatchPredictionsPublisher publisher = client.describeBatchPredictionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBatchPredictions(software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeBatchPredictionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeBatchPredictions
     */
    default DescribeBatchPredictionsPublisher describeBatchPredictionsPaginator(
            DescribeBatchPredictionsRequest describeBatchPredictionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeBatchPredictions(software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeBatchPredictionsPublisher publisher = client.describeBatchPredictionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeBatchPredictionsPublisher publisher = client.describeBatchPredictionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBatchPredictions(software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBatchPredictionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeBatchPredictionsRequest#builder()}
     * </p>
     *
     * @param describeBatchPredictionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBatchPredictionsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeBatchPredictions
     */
    default DescribeBatchPredictionsPublisher describeBatchPredictionsPaginator(
            Consumer<DescribeBatchPredictionsRequest.Builder> describeBatchPredictionsRequest) {
        return describeBatchPredictionsPaginator(DescribeBatchPredictionsRequest.builder()
                .applyMutation(describeBatchPredictionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DataSource</code> that match the search criteria in the request.
     * </p>
     *
     * @param describeDataSourcesRequest
     * @return A Java Future containing the result of the DescribeDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeDataSources
     */
    default CompletableFuture<DescribeDataSourcesResponse> describeDataSources(
            DescribeDataSourcesRequest describeDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DataSource</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataSourcesRequest#builder()}
     * </p>
     *
     * @param describeDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSourcesInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeDataSources
     */
    default CompletableFuture<DescribeDataSourcesResponse> describeDataSources(
            Consumer<DescribeDataSourcesRequest.Builder> describeDataSourcesRequest) {
        return describeDataSources(DescribeDataSourcesRequest.builder().applyMutation(describeDataSourcesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DataSource</code> that match the search criteria in the request.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeDataSources
     */
    default CompletableFuture<DescribeDataSourcesResponse> describeDataSources() {
        return describeDataSources(DescribeDataSourcesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DataSource</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataSources(software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeDataSourcesPublisher publisher = client.describeDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeDataSourcesPublisher publisher = client.describeDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataSources(software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeDataSources
     */
    default DescribeDataSourcesPublisher describeDataSourcesPaginator() {
        return describeDataSourcesPaginator(DescribeDataSourcesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DataSource</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataSources(software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeDataSourcesPublisher publisher = client.describeDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeDataSourcesPublisher publisher = client.describeDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataSources(software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDataSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeDataSources
     */
    default DescribeDataSourcesPublisher describeDataSourcesPaginator(DescribeDataSourcesRequest describeDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DataSource</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataSources(software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeDataSourcesPublisher publisher = client.describeDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeDataSourcesPublisher publisher = client.describeDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataSources(software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSourcesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataSourcesRequest#builder()}
     * </p>
     *
     * @param describeDataSourcesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSourcesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeDataSources
     */
    default DescribeDataSourcesPublisher describeDataSourcesPaginator(
            Consumer<DescribeDataSourcesRequest.Builder> describeDataSourcesRequest) {
        return describeDataSourcesPaginator(DescribeDataSourcesRequest.builder().applyMutation(describeDataSourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.
     * </p>
     *
     * @param describeEvaluationsRequest
     * @return A Java Future containing the result of the DescribeEvaluations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeEvaluations
     */
    default CompletableFuture<DescribeEvaluationsResponse> describeEvaluations(
            DescribeEvaluationsRequest describeEvaluationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEvaluationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEvaluationsRequest#builder()}
     * </p>
     *
     * @param describeEvaluationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEvaluationsInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEvaluations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeEvaluations
     */
    default CompletableFuture<DescribeEvaluationsResponse> describeEvaluations(
            Consumer<DescribeEvaluationsRequest.Builder> describeEvaluationsRequest) {
        return describeEvaluations(DescribeEvaluationsRequest.builder().applyMutation(describeEvaluationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEvaluations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeEvaluations
     */
    default CompletableFuture<DescribeEvaluationsResponse> describeEvaluations() {
        return describeEvaluations(DescribeEvaluationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvaluations(software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeEvaluationsPublisher publisher = client.describeEvaluationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeEvaluationsPublisher publisher = client.describeEvaluationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvaluations(software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeEvaluations
     */
    default DescribeEvaluationsPublisher describeEvaluationsPaginator() {
        return describeEvaluationsPaginator(DescribeEvaluationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvaluations(software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeEvaluationsPublisher publisher = client.describeEvaluationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeEvaluationsPublisher publisher = client.describeEvaluationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvaluations(software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEvaluationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeEvaluations
     */
    default DescribeEvaluationsPublisher describeEvaluationsPaginator(DescribeEvaluationsRequest describeEvaluationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvaluations(software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeEvaluationsPublisher publisher = client.describeEvaluationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeEvaluationsPublisher publisher = client.describeEvaluationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvaluations(software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEvaluationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEvaluationsRequest#builder()}
     * </p>
     *
     * @param describeEvaluationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEvaluationsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeEvaluations
     */
    default DescribeEvaluationsPublisher describeEvaluationsPaginator(
            Consumer<DescribeEvaluationsRequest.Builder> describeEvaluationsRequest) {
        return describeEvaluationsPaginator(DescribeEvaluationsRequest.builder().applyMutation(describeEvaluationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>MLModel</code> that match the search criteria in the request.
     * </p>
     *
     * @param describeMlModelsRequest
     * @return A Java Future containing the result of the DescribeMLModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeMLModels
     */
    default CompletableFuture<DescribeMlModelsResponse> describeMLModels(DescribeMlModelsRequest describeMlModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>MLModel</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMlModelsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeMlModelsRequest#builder()}
     * </p>
     *
     * @param describeMlModelsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMLModelsInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeMLModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeMLModels
     */
    default CompletableFuture<DescribeMlModelsResponse> describeMLModels(
            Consumer<DescribeMlModelsRequest.Builder> describeMlModelsRequest) {
        return describeMLModels(DescribeMlModelsRequest.builder().applyMutation(describeMlModelsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>MLModel</code> that match the search criteria in the request.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeMLModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeMLModels
     */
    default CompletableFuture<DescribeMlModelsResponse> describeMLModels() {
        return describeMLModels(DescribeMlModelsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>MLModel</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMLModels(software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeMLModelsPublisher publisher = client.describeMLModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeMLModelsPublisher publisher = client.describeMLModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMLModels(software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeMLModels
     */
    default DescribeMLModelsPublisher describeMLModelsPaginator() {
        return describeMLModelsPaginator(DescribeMlModelsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>MLModel</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMLModels(software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeMLModelsPublisher publisher = client.describeMLModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeMLModelsPublisher publisher = client.describeMLModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMLModels(software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMlModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeMLModels
     */
    default DescribeMLModelsPublisher describeMLModelsPaginator(DescribeMlModelsRequest describeMlModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>MLModel</code> that match the search criteria in the request.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMLModels(software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeMLModelsPublisher publisher = client.describeMLModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.machinelearning.paginators.DescribeMLModelsPublisher publisher = client.describeMLModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMLModels(software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMlModelsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeMlModelsRequest#builder()}
     * </p>
     *
     * @param describeMlModelsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMLModelsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeMLModels
     */
    default DescribeMLModelsPublisher describeMLModelsPaginator(Consumer<DescribeMlModelsRequest.Builder> describeMlModelsRequest) {
        return describeMLModelsPaginator(DescribeMlModelsRequest.builder().applyMutation(describeMlModelsRequest).build());
    }

    /**
     * <p>
     * Describes one or more of the tags for your Amazon ML object.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeTags
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of the tags for your Amazon ML object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTagsInput.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.DescribeTags
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Returns a <code>BatchPrediction</code> that includes detailed metadata, status, and data file information for a
     * <code>Batch Prediction</code> request.
     * </p>
     *
     * @param getBatchPredictionRequest
     * @return A Java Future containing the result of the GetBatchPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.GetBatchPrediction
     */
    default CompletableFuture<GetBatchPredictionResponse> getBatchPrediction(GetBatchPredictionRequest getBatchPredictionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <code>BatchPrediction</code> that includes detailed metadata, status, and data file information for a
     * <code>Batch Prediction</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBatchPredictionRequest.Builder} avoiding the
     * need to create one manually via {@link GetBatchPredictionRequest#builder()}
     * </p>
     *
     * @param getBatchPredictionRequest
     *        A {@link Consumer} that will call methods on {@link GetBatchPredictionInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetBatchPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.GetBatchPrediction
     */
    default CompletableFuture<GetBatchPredictionResponse> getBatchPrediction(
            Consumer<GetBatchPredictionRequest.Builder> getBatchPredictionRequest) {
        return getBatchPrediction(GetBatchPredictionRequest.builder().applyMutation(getBatchPredictionRequest).build());
    }

    /**
     * <p>
     * Returns a <code>DataSource</code> that includes metadata and data file information, as well as the current status
     * of the <code>DataSource</code>.
     * </p>
     * <p>
     * <code>GetDataSource</code> provides results in normal or verbose format. The verbose format adds the schema
     * description and the list of files pointed to by the DataSource to the normal format.
     * </p>
     *
     * @param getDataSourceRequest
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.GetDataSource
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(GetDataSourceRequest getDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <code>DataSource</code> that includes metadata and data file information, as well as the current status
     * of the <code>DataSource</code>.
     * </p>
     * <p>
     * <code>GetDataSource</code> provides results in normal or verbose format. The verbose format adds the schema
     * description and the list of files pointed to by the DataSource to the normal format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSourceRequest#builder()}
     * </p>
     *
     * @param getDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link GetDataSourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.GetDataSource
     */
    default CompletableFuture<GetDataSourceResponse> getDataSource(Consumer<GetDataSourceRequest.Builder> getDataSourceRequest) {
        return getDataSource(GetDataSourceRequest.builder().applyMutation(getDataSourceRequest).build());
    }

    /**
     * <p>
     * Returns an <code>Evaluation</code> that includes metadata as well as the current status of the
     * <code>Evaluation</code>.
     * </p>
     *
     * @param getEvaluationRequest
     * @return A Java Future containing the result of the GetEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.GetEvaluation
     */
    default CompletableFuture<GetEvaluationResponse> getEvaluation(GetEvaluationRequest getEvaluationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an <code>Evaluation</code> that includes metadata as well as the current status of the
     * <code>Evaluation</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEvaluationRequest.Builder} avoiding the need to
     * create one manually via {@link GetEvaluationRequest#builder()}
     * </p>
     *
     * @param getEvaluationRequest
     *        A {@link Consumer} that will call methods on {@link GetEvaluationInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.GetEvaluation
     */
    default CompletableFuture<GetEvaluationResponse> getEvaluation(Consumer<GetEvaluationRequest.Builder> getEvaluationRequest) {
        return getEvaluation(GetEvaluationRequest.builder().applyMutation(getEvaluationRequest).build());
    }

    /**
     * <p>
     * Returns an <code>MLModel</code> that includes detailed metadata, data source information, and the current status
     * of the <code>MLModel</code>.
     * </p>
     * <p>
     * <code>GetMLModel</code> provides results in normal or verbose format.
     * </p>
     *
     * @param getMlModelRequest
     * @return A Java Future containing the result of the GetMLModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.GetMLModel
     */
    default CompletableFuture<GetMlModelResponse> getMLModel(GetMlModelRequest getMlModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an <code>MLModel</code> that includes detailed metadata, data source information, and the current status
     * of the <code>MLModel</code>.
     * </p>
     * <p>
     * <code>GetMLModel</code> provides results in normal or verbose format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlModelRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlModelRequest#builder()}
     * </p>
     *
     * @param getMlModelRequest
     *        A {@link Consumer} that will call methods on {@link GetMLModelInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetMLModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.GetMLModel
     */
    default CompletableFuture<GetMlModelResponse> getMLModel(Consumer<GetMlModelRequest.Builder> getMlModelRequest) {
        return getMLModel(GetMlModelRequest.builder().applyMutation(getMlModelRequest).build());
    }

    /**
     * <p>
     * Generates a prediction for the observation using the specified <code>ML Model</code>.
     * </p>
     * <p>
     * <b>Note:</b> Not all response parameters will be populated. Whether a response parameter is populated depends on
     * the type of model requested.
     * </p>
     *
     * @param predictRequest
     * @return A Java Future containing the result of the Predict operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>LimitExceededException The subscriber exceeded the maximum number of operations. This exception can
     *         occur when listing objects such as <code>DataSource</code>.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>PredictorNotMountedException The exception is thrown when a predict request is made to an unmounted
     *         <code>MLModel</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.Predict
     */
    default CompletableFuture<PredictResponse> predict(PredictRequest predictRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a prediction for the observation using the specified <code>ML Model</code>.
     * </p>
     * <p>
     * <b>Note:</b> Not all response parameters will be populated. Whether a response parameter is populated depends on
     * the type of model requested.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PredictRequest.Builder} avoiding the need to create
     * one manually via {@link PredictRequest#builder()}
     * </p>
     *
     * @param predictRequest
     *        A {@link Consumer} that will call methods on {@link PredictInput.Builder} to create a request.
     * @return A Java Future containing the result of the Predict operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>LimitExceededException The subscriber exceeded the maximum number of operations. This exception can
     *         occur when listing objects such as <code>DataSource</code>.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>PredictorNotMountedException The exception is thrown when a predict request is made to an unmounted
     *         <code>MLModel</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.Predict
     */
    default CompletableFuture<PredictResponse> predict(Consumer<PredictRequest.Builder> predictRequest) {
        return predict(PredictRequest.builder().applyMutation(predictRequest).build());
    }

    /**
     * <p>
     * Updates the <code>BatchPredictionName</code> of a <code>BatchPrediction</code>.
     * </p>
     * <p>
     * You can use the <code>GetBatchPrediction</code> operation to view the contents of the updated data element.
     * </p>
     *
     * @param updateBatchPredictionRequest
     * @return A Java Future containing the result of the UpdateBatchPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.UpdateBatchPrediction
     */
    default CompletableFuture<UpdateBatchPredictionResponse> updateBatchPrediction(
            UpdateBatchPredictionRequest updateBatchPredictionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the <code>BatchPredictionName</code> of a <code>BatchPrediction</code>.
     * </p>
     * <p>
     * You can use the <code>GetBatchPrediction</code> operation to view the contents of the updated data element.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBatchPredictionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBatchPredictionRequest#builder()}
     * </p>
     *
     * @param updateBatchPredictionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBatchPredictionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBatchPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.UpdateBatchPrediction
     */
    default CompletableFuture<UpdateBatchPredictionResponse> updateBatchPrediction(
            Consumer<UpdateBatchPredictionRequest.Builder> updateBatchPredictionRequest) {
        return updateBatchPrediction(UpdateBatchPredictionRequest.builder().applyMutation(updateBatchPredictionRequest).build());
    }

    /**
     * <p>
     * Updates the <code>DataSourceName</code> of a <code>DataSource</code>.
     * </p>
     * <p>
     * You can use the <code>GetDataSource</code> operation to view the contents of the updated data element.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.UpdateDataSource
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the <code>DataSourceName</code> of a <code>DataSource</code>.
     * </p>
     * <p>
     * You can use the <code>GetDataSource</code> operation to view the contents of the updated data element.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDataSourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.UpdateDataSource
     */
    default CompletableFuture<UpdateDataSourceResponse> updateDataSource(
            Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest) {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Updates the <code>EvaluationName</code> of an <code>Evaluation</code>.
     * </p>
     * <p>
     * You can use the <code>GetEvaluation</code> operation to view the contents of the updated data element.
     * </p>
     *
     * @param updateEvaluationRequest
     * @return A Java Future containing the result of the UpdateEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.UpdateEvaluation
     */
    default CompletableFuture<UpdateEvaluationResponse> updateEvaluation(UpdateEvaluationRequest updateEvaluationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the <code>EvaluationName</code> of an <code>Evaluation</code>.
     * </p>
     * <p>
     * You can use the <code>GetEvaluation</code> operation to view the contents of the updated data element.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEvaluationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEvaluationRequest#builder()}
     * </p>
     *
     * @param updateEvaluationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEvaluationInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateEvaluation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.UpdateEvaluation
     */
    default CompletableFuture<UpdateEvaluationResponse> updateEvaluation(
            Consumer<UpdateEvaluationRequest.Builder> updateEvaluationRequest) {
        return updateEvaluation(UpdateEvaluationRequest.builder().applyMutation(updateEvaluationRequest).build());
    }

    /**
     * <p>
     * Updates the <code>MLModelName</code> and the <code>ScoreThreshold</code> of an <code>MLModel</code>.
     * </p>
     * <p>
     * You can use the <code>GetMLModel</code> operation to view the contents of the updated data element.
     * </p>
     *
     * @param updateMlModelRequest
     * @return A Java Future containing the result of the UpdateMLModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.UpdateMLModel
     */
    default CompletableFuture<UpdateMlModelResponse> updateMLModel(UpdateMlModelRequest updateMlModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the <code>MLModelName</code> and the <code>ScoreThreshold</code> of an <code>MLModel</code>.
     * </p>
     * <p>
     * You can use the <code>GetMLModel</code> operation to view the contents of the updated data element.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMlModelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMlModelRequest#builder()}
     * </p>
     *
     * @param updateMlModelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMLModelInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateMLModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException An error on the client occurred. Typically, the cause is an invalid input
     *         value.</li>
     *         <li>ResourceNotFoundException A specified resource cannot be located.</li>
     *         <li>InternalServerException An error on the server occurred when trying to process a request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MachineLearningException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample MachineLearningAsyncClient.UpdateMLModel
     */
    default CompletableFuture<UpdateMlModelResponse> updateMLModel(Consumer<UpdateMlModelRequest.Builder> updateMlModelRequest) {
        return updateMLModel(UpdateMlModelRequest.builder().applyMutation(updateMlModelRequest).build());
    }

    /**
     * Create an instance of {@link MachineLearningAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link MachineLearningAsyncWaiter}
     */
    default MachineLearningAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default MachineLearningServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MachineLearningAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MachineLearningAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MachineLearningAsyncClient}.
     */
    static MachineLearningAsyncClientBuilder builder() {
        return new DefaultMachineLearningAsyncClientBuilder();
    }
}
