/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MLModelType {
    REGRESSION("REGRESSION"),
    BINARY("BINARY"),
    MULTICLASS("MULTICLASS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MLModelType> VALUE_MAP;
    private final String value;

    private MLModelType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MLModelType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MLModelType> knownValues() {
        EnumSet<MLModelType> knownValues = EnumSet.allOf(MLModelType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MLModelType.class, MLModelType::toString);
    }
}

