/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NetworkStatus {
    CREATING("CREATING"),
    AVAILABLE("AVAILABLE"),
    CREATE_FAILED("CREATE_FAILED"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NetworkStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NetworkStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkStatus> knownValues() {
        return Stream.of(NetworkStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

