/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacecatalog.model.MarketplaceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeChangeSetRequest
extends MarketplaceCatalogRequest
implements ToCopyableBuilder<Builder, DescribeChangeSetRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(DescribeChangeSetRequest.getter(DescribeChangeSetRequest::catalog)).setter(DescribeChangeSetRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("catalog").build()}).build();
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetId").getter(DescribeChangeSetRequest.getter(DescribeChangeSetRequest::changeSetId)).setter(DescribeChangeSetRequest.setter(Builder::changeSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("changeSetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CHANGE_SET_ID_FIELD));
    private final String catalog;
    private final String changeSetId;

    private DescribeChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.changeSetId = builder.changeSetId;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String changeSetId() {
        return this.changeSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChangeSetRequest)) {
            return false;
        }
        DescribeChangeSetRequest other = (DescribeChangeSetRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.changeSetId(), other.changeSetId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeChangeSetRequest").add("Catalog", (Object)this.catalog()).add("ChangeSetId", (Object)this.changeSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "ChangeSetId": {
                return Optional.ofNullable(clazz.cast(this.changeSetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChangeSetRequest, T> g) {
        return obj -> g.apply((DescribeChangeSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceCatalogRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private String changeSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChangeSetRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.changeSetId(model.changeSetId);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeChangeSetRequest build() {
            return new DescribeChangeSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeChangeSetRequest> {
        public Builder catalog(String var1);

        public Builder changeSetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

