/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntitySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntitySummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EntitySummary.getter(EntitySummary::name)).setter(EntitySummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityType").getter(EntitySummary.getter(EntitySummary::entityType)).setter(EntitySummary.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityId").getter(EntitySummary.getter(EntitySummary::entityId)).setter(EntitySummary.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityArn").getter(EntitySummary.getter(EntitySummary::entityArn)).setter(EntitySummary.setter(Builder::entityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedDate").getter(EntitySummary.getter(EntitySummary::lastModifiedDate)).setter(EntitySummary.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(EntitySummary.getter(EntitySummary::visibility)).setter(EntitySummary.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ENTITY_TYPE_FIELD, ENTITY_ID_FIELD, ENTITY_ARN_FIELD, LAST_MODIFIED_DATE_FIELD, VISIBILITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String entityType;
    private final String entityId;
    private final String entityArn;
    private final String lastModifiedDate;
    private final String visibility;

    private EntitySummary(BuilderImpl builder) {
        this.name = builder.name;
        this.entityType = builder.entityType;
        this.entityId = builder.entityId;
        this.entityArn = builder.entityArn;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.visibility = builder.visibility;
    }

    public final String name() {
        return this.name;
    }

    public final String entityType() {
        return this.entityType;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityArn() {
        return this.entityArn;
    }

    public final String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String visibility() {
        return this.visibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibility());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitySummary)) {
            return false;
        }
        EntitySummary other = (EntitySummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.entityType(), other.entityType()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityArn(), other.entityArn()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.visibility(), other.visibility());
    }

    public final String toString() {
        return ToString.builder((String)"EntitySummary").add("Name", (Object)this.name()).add("EntityType", (Object)this.entityType()).add("EntityId", (Object)this.entityId()).add("EntityArn", (Object)this.entityArn()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Visibility", (Object)this.visibility()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EntityType": {
                return Optional.ofNullable(clazz.cast(this.entityType()));
            }
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "EntityArn": {
                return Optional.ofNullable(clazz.cast(this.entityArn()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibility()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntitySummary, T> g) {
        return obj -> g.apply((EntitySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String entityType;
        private String entityId;
        private String entityArn;
        private String lastModifiedDate;
        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(EntitySummary model) {
            this.name(model.name);
            this.entityType(model.entityType);
            this.entityId(model.entityId);
            this.entityArn(model.entityArn);
            this.lastModifiedDate(model.lastModifiedDate);
            this.visibility(model.visibility);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public final String getEntityArn() {
            return this.entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public EntitySummary build() {
            return new EntitySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntitySummary> {
        public Builder name(String var1);

        public Builder entityType(String var1);

        public Builder entityId(String var1);

        public Builder entityArn(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder visibility(String var1);
    }
}

