/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacecatalog.model.AmiProductVisibilityString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmiProductSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmiProductSummary> {
    private static final SdkField<String> PRODUCT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductTitle").getter(AmiProductSummary.getter(AmiProductSummary::productTitle)).setter(AmiProductSummary.setter(Builder::productTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(AmiProductSummary.getter(AmiProductSummary::visibilityAsString)).setter(AmiProductSummary.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_TITLE_FIELD, VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AmiProductSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String productTitle;
    private final String visibility;

    private AmiProductSummary(BuilderImpl builder) {
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
    }

    public final String productTitle() {
        return this.productTitle;
    }

    public final AmiProductVisibilityString visibility() {
        return AmiProductVisibilityString.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiProductSummary)) {
            return false;
        }
        AmiProductSummary other = (AmiProductSummary)obj;
        return Objects.equals(this.productTitle(), other.productTitle()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AmiProductSummary").add("ProductTitle", (Object)this.productTitle()).add("Visibility", (Object)this.visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductTitle": {
                return Optional.ofNullable(clazz.cast(this.productTitle()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ProductTitle", PRODUCT_TITLE_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmiProductSummary, T> g) {
        return obj -> g.apply((AmiProductSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productTitle;
        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiProductSummary model) {
            this.productTitle(model.productTitle);
            this.visibility(model.visibility);
        }

        public final String getProductTitle() {
            return this.productTitle;
        }

        public final void setProductTitle(String productTitle) {
            this.productTitle = productTitle;
        }

        @Override
        public final Builder productTitle(String productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(AmiProductVisibilityString visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public AmiProductSummary build() {
            return new AmiProductSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmiProductSummary> {
        public Builder productTitle(String var1);

        public Builder visibility(String var1);

        public Builder visibility(AmiProductVisibilityString var1);
    }
}

