/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Intent {
    VALIDATE("VALIDATE"),
    APPLY("APPLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Intent> VALUE_MAP;
    private final String value;

    private Intent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Intent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Intent> knownValues() {
        EnumSet<Intent> knownValues = EnumSet.allOf(Intent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Intent.class, Intent::toString);
    }
}

