/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.marketplacecatalog.MarketplaceCatalogClient;
import software.amazon.awssdk.services.marketplacecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.marketplacecatalog.model.ChangeSetSummaryListItem;
import software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsRequest;
import software.amazon.awssdk.services.marketplacecatalog.model.ListChangeSetsResponse;

public class ListChangeSetsIterable
implements SdkIterable<ListChangeSetsResponse> {
    private final MarketplaceCatalogClient client;
    private final ListChangeSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChangeSetsIterable(MarketplaceCatalogClient client, ListChangeSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChangeSetsResponseFetcher();
    }

    public Iterator<ListChangeSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChangeSetSummaryListItem> changeSetSummaryList() {
        Function<ListChangeSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.changeSetSummaryList() != null) {
                return response.changeSetSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListChangeSetsResponseFetcher
    implements SyncPageFetcher<ListChangeSetsResponse> {
        private ListChangeSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListChangeSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChangeSetsResponse nextPage(ListChangeSetsResponse previousPage) {
            if (previousPage == null) {
                return ListChangeSetsIterable.this.client.listChangeSets(ListChangeSetsIterable.this.firstRequest);
            }
            return ListChangeSetsIterable.this.client.listChangeSets((ListChangeSetsRequest)((Object)ListChangeSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

