/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A MediaPackage VOD Asset resource.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetShallow implements SdkPojo, Serializable, ToCopyableBuilder<AssetShallow.Builder, AssetShallow> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssetShallow::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssetShallow::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssetShallow::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PACKAGING_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssetShallow::packagingGroupId)).setter(setter(Builder::packagingGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingGroupId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssetShallow::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssetShallow::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()).build();

    private static final SdkField<String> SOURCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssetShallow::sourceRoleArn)).setter(setter(Builder::sourceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            ID_FIELD, PACKAGING_GROUP_ID_FIELD, RESOURCE_ID_FIELD, SOURCE_ARN_FIELD, SOURCE_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String createdAt;

    private final String id;

    private final String packagingGroupId;

    private final String resourceId;

    private final String sourceArn;

    private final String sourceRoleArn;

    private AssetShallow(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.packagingGroupId = builder.packagingGroupId;
        this.resourceId = builder.resourceId;
        this.sourceArn = builder.sourceArn;
        this.sourceRoleArn = builder.sourceRoleArn;
    }

    /**
     * The ARN of the Asset.
     * 
     * @return The ARN of the Asset.
     */
    public String arn() {
        return arn;
    }

    /**
     * The time the Asset was initially submitted for Ingest.
     * 
     * @return The time the Asset was initially submitted for Ingest.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * The unique identifier for the Asset.
     * 
     * @return The unique identifier for the Asset.
     */
    public String id() {
        return id;
    }

    /**
     * The ID of the PackagingGroup for the Asset.
     * 
     * @return The ID of the PackagingGroup for the Asset.
     */
    public String packagingGroupId() {
        return packagingGroupId;
    }

    /**
     * The resource ID to include in SPEKE key requests.
     * 
     * @return The resource ID to include in SPEKE key requests.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * ARN of the source object in S3.
     * 
     * @return ARN of the source object in S3.
     */
    public String sourceArn() {
        return sourceArn;
    }

    /**
     * The IAM role ARN used to access the source S3 bucket.
     * 
     * @return The IAM role ARN used to access the source S3 bucket.
     */
    public String sourceRoleArn() {
        return sourceRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(packagingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetShallow)) {
            return false;
        }
        AssetShallow other = (AssetShallow) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(id(), other.id()) && Objects.equals(packagingGroupId(), other.packagingGroupId())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(sourceRoleArn(), other.sourceRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssetShallow").add("Arn", arn()).add("CreatedAt", createdAt()).add("Id", id())
                .add("PackagingGroupId", packagingGroupId()).add("ResourceId", resourceId()).add("SourceArn", sourceArn())
                .add("SourceRoleArn", sourceRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "PackagingGroupId":
            return Optional.ofNullable(clazz.cast(packagingGroupId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "SourceRoleArn":
            return Optional.ofNullable(clazz.cast(sourceRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetShallow, T> g) {
        return obj -> g.apply((AssetShallow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetShallow> {
        /**
         * The ARN of the Asset.
         * 
         * @param arn
         *        The ARN of the Asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The time the Asset was initially submitted for Ingest.
         * 
         * @param createdAt
         *        The time the Asset was initially submitted for Ingest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * The unique identifier for the Asset.
         * 
         * @param id
         *        The unique identifier for the Asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The ID of the PackagingGroup for the Asset.
         * 
         * @param packagingGroupId
         *        The ID of the PackagingGroup for the Asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagingGroupId(String packagingGroupId);

        /**
         * The resource ID to include in SPEKE key requests.
         * 
         * @param resourceId
         *        The resource ID to include in SPEKE key requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * ARN of the source object in S3.
         * 
         * @param sourceArn
         *        ARN of the source object in S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * The IAM role ARN used to access the source S3 bucket.
         * 
         * @param sourceRoleArn
         *        The IAM role ARN used to access the source S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRoleArn(String sourceRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String createdAt;

        private String id;

        private String packagingGroupId;

        private String resourceId;

        private String sourceArn;

        private String sourceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetShallow model) {
            arn(model.arn);
            createdAt(model.createdAt);
            id(model.id);
            packagingGroupId(model.packagingGroupId);
            resourceId(model.resourceId);
            sourceArn(model.sourceArn);
            sourceRoleArn(model.sourceRoleArn);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getPackagingGroupId() {
            return packagingGroupId;
        }

        @Override
        public final Builder packagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
            return this;
        }

        public final void setPackagingGroupId(String packagingGroupId) {
            this.packagingGroupId = packagingGroupId;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getSourceRoleArn() {
            return sourceRoleArn;
        }

        @Override
        public final Builder sourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
            return this;
        }

        public final void setSourceRoleArn(String sourceRoleArn) {
            this.sourceRoleArn = sourceRoleArn;
        }

        @Override
        public AssetShallow build() {
            return new AssetShallow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
