/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashPackage implements SdkPojo, Serializable, ToCopyableBuilder<DashPackage.Builder, DashPackage> {
    private static final SdkField<List<DashManifest>> DASH_MANIFESTS_FIELD = SdkField
            .<List<DashManifest>> builder(MarshallingType.LIST)
            .getter(getter(DashPackage::dashManifests))
            .setter(setter(Builder::dashManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DashManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(DashManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DashEncryption> ENCRYPTION_FIELD = SdkField.<DashEncryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(DashPackage::encryption)).setter(setter(Builder::encryption)).constructor(DashEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::segmentDurationSeconds)).setter(setter(Builder::segmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASH_MANIFESTS_FIELD,
            ENCRYPTION_FIELD, SEGMENT_DURATION_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DashManifest> dashManifests;

    private final DashEncryption encryption;

    private final Integer segmentDurationSeconds;

    private DashPackage(BuilderImpl builder) {
        this.dashManifests = builder.dashManifests;
        this.encryption = builder.encryption;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
    }

    /**
     * Returns true if the DashManifests property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDashManifests() {
        return dashManifests != null && !(dashManifests instanceof SdkAutoConstructList);
    }

    /**
     * A list of DASH manifest configurations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDashManifests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of DASH manifest configurations.
     */
    public List<DashManifest> dashManifests() {
        return dashManifests;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public DashEncryption encryption() {
        return encryption;
    }

    /**
     * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source
     * segment duration.
     *
     * @return Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the
     *         source segment duration.
     */
    public Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashManifests());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashPackage)) {
            return false;
        }
        DashPackage other = (DashPackage) obj;
        return Objects.equals(dashManifests(), other.dashManifests()) && Objects.equals(encryption(), other.encryption())
                && Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DashPackage").add("DashManifests", dashManifests()).add("Encryption", encryption())
                .add("SegmentDurationSeconds", segmentDurationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashManifests":
            return Optional.ofNullable(clazz.cast(dashManifests()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "SegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(segmentDurationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashPackage, T> g) {
        return obj -> g.apply((DashPackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashPackage> {
        /**
         * A list of DASH manifest configurations.
         * 
         * @param dashManifests
         *        A list of DASH manifest configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashManifests(Collection<DashManifest> dashManifests);

        /**
         * A list of DASH manifest configurations.
         * 
         * @param dashManifests
         *        A list of DASH manifest configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashManifests(DashManifest... dashManifests);

        /**
         * A list of DASH manifest configurations. This is a convenience that creates an instance of the {@link List
         * <DashManifest>.Builder} avoiding the need to create one manually via {@link List<DashManifest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DashManifest>.Builder#build()} is called immediately and its
         * result is passed to {@link #dashManifests(List<DashManifest>)}.
         * 
         * @param dashManifests
         *        a consumer that will call methods on {@link List<DashManifest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashManifests(List<DashManifest>)
         */
        Builder dashManifests(Consumer<DashManifest.Builder>... dashManifests);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(DashEncryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience that creates an instance of the {@link DashEncryption.Builder} avoiding the need to
         * create one manually via {@link DashEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(DashEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link DashEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(DashEncryption)
         */
        default Builder encryption(Consumer<DashEncryption.Builder> encryption) {
            return encryption(DashEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source
         * segment duration.
         *
         * @param segmentDurationSeconds
         *        Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the
         *        source segment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);
    }

    static final class BuilderImpl implements Builder {
        private List<DashManifest> dashManifests = DefaultSdkAutoConstructList.getInstance();

        private DashEncryption encryption;

        private Integer segmentDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DashPackage model) {
            dashManifests(model.dashManifests);
            encryption(model.encryption);
            segmentDurationSeconds(model.segmentDurationSeconds);
        }

        public final Collection<DashManifest.Builder> getDashManifests() {
            return dashManifests != null ? dashManifests.stream().map(DashManifest::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder dashManifests(Collection<DashManifest> dashManifests) {
            this.dashManifests = ___listOfDashManifestCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(DashManifest... dashManifests) {
            dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<DashManifest.Builder>... dashManifests) {
            dashManifests(Stream.of(dashManifests).map(c -> DashManifest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDashManifests(Collection<DashManifest.BuilderImpl> dashManifests) {
            this.dashManifests = ___listOfDashManifestCopier.copyFromBuilder(dashManifests);
        }

        public final DashEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(DashEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(DashEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        @Override
        public DashPackage build() {
            return new DashPackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
