/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The AWSMediaTailor configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlaybackConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PlaybackConfiguration.Builder, PlaybackConfiguration> {
    private static final SdkField<String> AD_DECISION_SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlaybackConfiguration::adDecisionServerUrl)).setter(setter(Builder::adDecisionServerUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdDecisionServerUrl").build())
            .build();

    private static final SdkField<CdnConfiguration> CDN_CONFIGURATION_FIELD = SdkField
            .<CdnConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(PlaybackConfiguration::cdnConfiguration))
            .setter(setter(Builder::cdnConfiguration)).constructor(CdnConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdnConfiguration").build()).build();

    private static final SdkField<DashConfiguration> DASH_CONFIGURATION_FIELD = SdkField
            .<DashConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(PlaybackConfiguration::dashConfiguration))
            .setter(setter(Builder::dashConfiguration)).constructor(DashConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashConfiguration").build()).build();

    private static final SdkField<HlsConfiguration> HLS_CONFIGURATION_FIELD = SdkField
            .<HlsConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(PlaybackConfiguration::hlsConfiguration))
            .setter(setter(Builder::hlsConfiguration)).constructor(HlsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsConfiguration").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlaybackConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PLAYBACK_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlaybackConfiguration::playbackConfigurationArn)).setter(setter(Builder::playbackConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackConfigurationArn").build())
            .build();

    private static final SdkField<String> PLAYBACK_ENDPOINT_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlaybackConfiguration::playbackEndpointPrefix)).setter(setter(Builder::playbackEndpointPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackEndpointPrefix").build())
            .build();

    private static final SdkField<String> SESSION_INITIALIZATION_ENDPOINT_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PlaybackConfiguration::sessionInitializationEndpointPrefix))
            .setter(setter(Builder::sessionInitializationEndpointPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SessionInitializationEndpointPrefix").build()).build();

    private static final SdkField<String> SLATE_AD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlaybackConfiguration::slateAdUrl)).setter(setter(Builder::slateAdUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlateAdUrl").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(PlaybackConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TRANSCODE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlaybackConfiguration::transcodeProfileName)).setter(setter(Builder::transcodeProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscodeProfileName").build())
            .build();

    private static final SdkField<String> VIDEO_CONTENT_SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlaybackConfiguration::videoContentSourceUrl)).setter(setter(Builder::videoContentSourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoContentSourceUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_DECISION_SERVER_URL_FIELD,
            CDN_CONFIGURATION_FIELD, DASH_CONFIGURATION_FIELD, HLS_CONFIGURATION_FIELD, NAME_FIELD,
            PLAYBACK_CONFIGURATION_ARN_FIELD, PLAYBACK_ENDPOINT_PREFIX_FIELD, SESSION_INITIALIZATION_ENDPOINT_PREFIX_FIELD,
            SLATE_AD_URL_FIELD, TAGS_FIELD, TRANSCODE_PROFILE_NAME_FIELD, VIDEO_CONTENT_SOURCE_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adDecisionServerUrl;

    private final CdnConfiguration cdnConfiguration;

    private final DashConfiguration dashConfiguration;

    private final HlsConfiguration hlsConfiguration;

    private final String name;

    private final String playbackConfigurationArn;

    private final String playbackEndpointPrefix;

    private final String sessionInitializationEndpointPrefix;

    private final String slateAdUrl;

    private final Map<String, String> tags;

    private final String transcodeProfileName;

    private final String videoContentSourceUrl;

    private PlaybackConfiguration(BuilderImpl builder) {
        this.adDecisionServerUrl = builder.adDecisionServerUrl;
        this.cdnConfiguration = builder.cdnConfiguration;
        this.dashConfiguration = builder.dashConfiguration;
        this.hlsConfiguration = builder.hlsConfiguration;
        this.name = builder.name;
        this.playbackConfigurationArn = builder.playbackConfigurationArn;
        this.playbackEndpointPrefix = builder.playbackEndpointPrefix;
        this.sessionInitializationEndpointPrefix = builder.sessionInitializationEndpointPrefix;
        this.slateAdUrl = builder.slateAdUrl;
        this.tags = builder.tags;
        this.transcodeProfileName = builder.transcodeProfileName;
        this.videoContentSourceUrl = builder.videoContentSourceUrl;
    }

    /**
     * <p>
     * The URL for the ad decision server (ADS). This includes the specification of static parameters and placeholders
     * for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as
     * needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is
     * 25,000 characters.
     * </p>
     * 
     * @return The URL for the ad decision server (ADS). This includes the specification of static parameters and
     *         placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and
     *         session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a
     *         static VAST URL. The maximum length is 25,000 characters.
     */
    public String adDecisionServerUrl() {
        return adDecisionServerUrl;
    }

    /**
     * <p>
     * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment
     * management.
     * </p>
     * 
     * @return The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad
     *         segment management.
     */
    public CdnConfiguration cdnConfiguration() {
        return cdnConfiguration;
    }

    /**
     * <p>
     * The configuration for DASH content.
     * </p>
     * 
     * @return The configuration for DASH content.
     */
    public DashConfiguration dashConfiguration() {
        return dashConfiguration;
    }

    /**
     * <p>
     * The configuration for HLS content.
     * </p>
     * 
     * @return The configuration for HLS content.
     */
    public HlsConfiguration hlsConfiguration() {
        return hlsConfiguration;
    }

    /**
     * <p>
     * The identifier for the playback configuration.
     * </p>
     * 
     * @return The identifier for the playback configuration.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the playback configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the playback configuration.
     */
    public String playbackConfigurationArn() {
        return playbackConfigurationArn;
    }

    /**
     * <p>
     * The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This session will use
     * server-side reporting.
     * </p>
     * 
     * @return The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This session will use
     *         server-side reporting.
     */
    public String playbackEndpointPrefix() {
        return playbackEndpointPrefix;
    }

    /**
     * <p>
     * The URL that the player uses to initialize a session that uses client-side reporting.
     * </p>
     * 
     * @return The URL that the player uses to initialize a session that uses client-side reporting.
     */
    public String sessionInitializationEndpointPrefix() {
        return sessionInitializationEndpointPrefix;
    }

    /**
     * <p>
     * The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads. AWS Elemental
     * MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID
     * playback configurations. For VPAID, the slate is required because MediaTailor provides it in the slots designated
     * for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.
     * </p>
     * 
     * @return The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads. AWS
     *         Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional
     *         for non-VPAID playback configurations. For VPAID, the slate is required because MediaTailor provides it
     *         in the slots designated for dynamic ad content. The slate must be a high-quality asset that contains both
     *         audio and video.
     */
    public String slateAdUrl() {
        return slateAdUrl;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the playback configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags assigned to the playback configuration.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The name that is used to associate this playback configuration with a custom transcode profile. This overrides
     * the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with
     * the help of AWS Support.
     * </p>
     * 
     * @return The name that is used to associate this playback configuration with a custom transcode profile. This
     *         overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up
     *         custom profiles with the help of AWS Support.
     */
    public String transcodeProfileName() {
        return transcodeProfileName;
    }

    /**
     * <p>
     * The URL prefix for the master playlist for the stream, minus the asset ID. The maximum length is 512 characters.
     * </p>
     * 
     * @return The URL prefix for the master playlist for the stream, minus the asset ID. The maximum length is 512
     *         characters.
     */
    public String videoContentSourceUrl() {
        return videoContentSourceUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adDecisionServerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(cdnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dashConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hlsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(playbackConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(playbackEndpointPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(sessionInitializationEndpointPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(slateAdUrl());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(transcodeProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(videoContentSourceUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlaybackConfiguration)) {
            return false;
        }
        PlaybackConfiguration other = (PlaybackConfiguration) obj;
        return Objects.equals(adDecisionServerUrl(), other.adDecisionServerUrl())
                && Objects.equals(cdnConfiguration(), other.cdnConfiguration())
                && Objects.equals(dashConfiguration(), other.dashConfiguration())
                && Objects.equals(hlsConfiguration(), other.hlsConfiguration()) && Objects.equals(name(), other.name())
                && Objects.equals(playbackConfigurationArn(), other.playbackConfigurationArn())
                && Objects.equals(playbackEndpointPrefix(), other.playbackEndpointPrefix())
                && Objects.equals(sessionInitializationEndpointPrefix(), other.sessionInitializationEndpointPrefix())
                && Objects.equals(slateAdUrl(), other.slateAdUrl()) && Objects.equals(tags(), other.tags())
                && Objects.equals(transcodeProfileName(), other.transcodeProfileName())
                && Objects.equals(videoContentSourceUrl(), other.videoContentSourceUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PlaybackConfiguration").add("AdDecisionServerUrl", adDecisionServerUrl())
                .add("CdnConfiguration", cdnConfiguration()).add("DashConfiguration", dashConfiguration())
                .add("HlsConfiguration", hlsConfiguration()).add("Name", name())
                .add("PlaybackConfigurationArn", playbackConfigurationArn())
                .add("PlaybackEndpointPrefix", playbackEndpointPrefix())
                .add("SessionInitializationEndpointPrefix", sessionInitializationEndpointPrefix())
                .add("SlateAdUrl", slateAdUrl()).add("Tags", tags()).add("TranscodeProfileName", transcodeProfileName())
                .add("VideoContentSourceUrl", videoContentSourceUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdDecisionServerUrl":
            return Optional.ofNullable(clazz.cast(adDecisionServerUrl()));
        case "CdnConfiguration":
            return Optional.ofNullable(clazz.cast(cdnConfiguration()));
        case "DashConfiguration":
            return Optional.ofNullable(clazz.cast(dashConfiguration()));
        case "HlsConfiguration":
            return Optional.ofNullable(clazz.cast(hlsConfiguration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PlaybackConfigurationArn":
            return Optional.ofNullable(clazz.cast(playbackConfigurationArn()));
        case "PlaybackEndpointPrefix":
            return Optional.ofNullable(clazz.cast(playbackEndpointPrefix()));
        case "SessionInitializationEndpointPrefix":
            return Optional.ofNullable(clazz.cast(sessionInitializationEndpointPrefix()));
        case "SlateAdUrl":
            return Optional.ofNullable(clazz.cast(slateAdUrl()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TranscodeProfileName":
            return Optional.ofNullable(clazz.cast(transcodeProfileName()));
        case "VideoContentSourceUrl":
            return Optional.ofNullable(clazz.cast(videoContentSourceUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlaybackConfiguration, T> g) {
        return obj -> g.apply((PlaybackConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlaybackConfiguration> {
        /**
         * <p>
         * The URL for the ad decision server (ADS). This includes the specification of static parameters and
         * placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and
         * session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a
         * static VAST URL. The maximum length is 25,000 characters.
         * </p>
         * 
         * @param adDecisionServerUrl
         *        The URL for the ad decision server (ADS). This includes the specification of static parameters and
         *        placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and
         *        session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide
         *        a static VAST URL. The maximum length is 25,000 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adDecisionServerUrl(String adDecisionServerUrl);

        /**
         * <p>
         * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad
         * segment management.
         * </p>
         * 
         * @param cdnConfiguration
         *        The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and
         *        ad segment management.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdnConfiguration(CdnConfiguration cdnConfiguration);

        /**
         * <p>
         * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad
         * segment management.
         * </p>
         * This is a convenience that creates an instance of the {@link CdnConfiguration.Builder} avoiding the need to
         * create one manually via {@link CdnConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CdnConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #cdnConfiguration(CdnConfiguration)}.
         * 
         * @param cdnConfiguration
         *        a consumer that will call methods on {@link CdnConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cdnConfiguration(CdnConfiguration)
         */
        default Builder cdnConfiguration(Consumer<CdnConfiguration.Builder> cdnConfiguration) {
            return cdnConfiguration(CdnConfiguration.builder().applyMutation(cdnConfiguration).build());
        }

        /**
         * <p>
         * The configuration for DASH content.
         * </p>
         * 
         * @param dashConfiguration
         *        The configuration for DASH content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashConfiguration(DashConfiguration dashConfiguration);

        /**
         * <p>
         * The configuration for DASH content.
         * </p>
         * This is a convenience that creates an instance of the {@link DashConfiguration.Builder} avoiding the need to
         * create one manually via {@link DashConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #dashConfiguration(DashConfiguration)}.
         * 
         * @param dashConfiguration
         *        a consumer that will call methods on {@link DashConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashConfiguration(DashConfiguration)
         */
        default Builder dashConfiguration(Consumer<DashConfiguration.Builder> dashConfiguration) {
            return dashConfiguration(DashConfiguration.builder().applyMutation(dashConfiguration).build());
        }

        /**
         * <p>
         * The configuration for HLS content.
         * </p>
         * 
         * @param hlsConfiguration
         *        The configuration for HLS content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsConfiguration(HlsConfiguration hlsConfiguration);

        /**
         * <p>
         * The configuration for HLS content.
         * </p>
         * This is a convenience that creates an instance of the {@link HlsConfiguration.Builder} avoiding the need to
         * create one manually via {@link HlsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #hlsConfiguration(HlsConfiguration)}.
         * 
         * @param hlsConfiguration
         *        a consumer that will call methods on {@link HlsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsConfiguration(HlsConfiguration)
         */
        default Builder hlsConfiguration(Consumer<HlsConfiguration.Builder> hlsConfiguration) {
            return hlsConfiguration(HlsConfiguration.builder().applyMutation(hlsConfiguration).build());
        }

        /**
         * <p>
         * The identifier for the playback configuration.
         * </p>
         * 
         * @param name
         *        The identifier for the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the playback configuration.
         * </p>
         * 
         * @param playbackConfigurationArn
         *        The Amazon Resource Name (ARN) for the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackConfigurationArn(String playbackConfigurationArn);

        /**
         * <p>
         * The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This session will use
         * server-side reporting.
         * </p>
         * 
         * @param playbackEndpointPrefix
         *        The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This session will
         *        use server-side reporting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackEndpointPrefix(String playbackEndpointPrefix);

        /**
         * <p>
         * The URL that the player uses to initialize a session that uses client-side reporting.
         * </p>
         * 
         * @param sessionInitializationEndpointPrefix
         *        The URL that the player uses to initialize a session that uses client-side reporting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionInitializationEndpointPrefix(String sessionInitializationEndpointPrefix);

        /**
         * <p>
         * The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads. AWS
         * Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for
         * non-VPAID playback configurations. For VPAID, the slate is required because MediaTailor provides it in the
         * slots designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and
         * video.
         * </p>
         * 
         * @param slateAdUrl
         *        The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads.
         *        AWS Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is
         *        optional for non-VPAID playback configurations. For VPAID, the slate is required because MediaTailor
         *        provides it in the slots designated for dynamic ad content. The slate must be a high-quality asset
         *        that contains both audio and video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slateAdUrl(String slateAdUrl);

        /**
         * <p>
         * The tags assigned to the playback configuration.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The name that is used to associate this playback configuration with a custom transcode profile. This
         * overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom
         * profiles with the help of AWS Support.
         * </p>
         * 
         * @param transcodeProfileName
         *        The name that is used to associate this playback configuration with a custom transcode profile. This
         *        overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up
         *        custom profiles with the help of AWS Support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcodeProfileName(String transcodeProfileName);

        /**
         * <p>
         * The URL prefix for the master playlist for the stream, minus the asset ID. The maximum length is 512
         * characters.
         * </p>
         * 
         * @param videoContentSourceUrl
         *        The URL prefix for the master playlist for the stream, minus the asset ID. The maximum length is 512
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoContentSourceUrl(String videoContentSourceUrl);
    }

    static final class BuilderImpl implements Builder {
        private String adDecisionServerUrl;

        private CdnConfiguration cdnConfiguration;

        private DashConfiguration dashConfiguration;

        private HlsConfiguration hlsConfiguration;

        private String name;

        private String playbackConfigurationArn;

        private String playbackEndpointPrefix;

        private String sessionInitializationEndpointPrefix;

        private String slateAdUrl;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String transcodeProfileName;

        private String videoContentSourceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(PlaybackConfiguration model) {
            adDecisionServerUrl(model.adDecisionServerUrl);
            cdnConfiguration(model.cdnConfiguration);
            dashConfiguration(model.dashConfiguration);
            hlsConfiguration(model.hlsConfiguration);
            name(model.name);
            playbackConfigurationArn(model.playbackConfigurationArn);
            playbackEndpointPrefix(model.playbackEndpointPrefix);
            sessionInitializationEndpointPrefix(model.sessionInitializationEndpointPrefix);
            slateAdUrl(model.slateAdUrl);
            tags(model.tags);
            transcodeProfileName(model.transcodeProfileName);
            videoContentSourceUrl(model.videoContentSourceUrl);
        }

        public final String getAdDecisionServerUrl() {
            return adDecisionServerUrl;
        }

        @Override
        public final Builder adDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
            return this;
        }

        public final void setAdDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
        }

        public final CdnConfiguration.Builder getCdnConfiguration() {
            return cdnConfiguration != null ? cdnConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cdnConfiguration(CdnConfiguration cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration;
            return this;
        }

        public final void setCdnConfiguration(CdnConfiguration.BuilderImpl cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration != null ? cdnConfiguration.build() : null;
        }

        public final DashConfiguration.Builder getDashConfiguration() {
            return dashConfiguration != null ? dashConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dashConfiguration(DashConfiguration dashConfiguration) {
            this.dashConfiguration = dashConfiguration;
            return this;
        }

        public final void setDashConfiguration(DashConfiguration.BuilderImpl dashConfiguration) {
            this.dashConfiguration = dashConfiguration != null ? dashConfiguration.build() : null;
        }

        public final HlsConfiguration.Builder getHlsConfiguration() {
            return hlsConfiguration != null ? hlsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder hlsConfiguration(HlsConfiguration hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration;
            return this;
        }

        public final void setHlsConfiguration(HlsConfiguration.BuilderImpl hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration != null ? hlsConfiguration.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPlaybackConfigurationArn() {
            return playbackConfigurationArn;
        }

        @Override
        public final Builder playbackConfigurationArn(String playbackConfigurationArn) {
            this.playbackConfigurationArn = playbackConfigurationArn;
            return this;
        }

        public final void setPlaybackConfigurationArn(String playbackConfigurationArn) {
            this.playbackConfigurationArn = playbackConfigurationArn;
        }

        public final String getPlaybackEndpointPrefix() {
            return playbackEndpointPrefix;
        }

        @Override
        public final Builder playbackEndpointPrefix(String playbackEndpointPrefix) {
            this.playbackEndpointPrefix = playbackEndpointPrefix;
            return this;
        }

        public final void setPlaybackEndpointPrefix(String playbackEndpointPrefix) {
            this.playbackEndpointPrefix = playbackEndpointPrefix;
        }

        public final String getSessionInitializationEndpointPrefix() {
            return sessionInitializationEndpointPrefix;
        }

        @Override
        public final Builder sessionInitializationEndpointPrefix(String sessionInitializationEndpointPrefix) {
            this.sessionInitializationEndpointPrefix = sessionInitializationEndpointPrefix;
            return this;
        }

        public final void setSessionInitializationEndpointPrefix(String sessionInitializationEndpointPrefix) {
            this.sessionInitializationEndpointPrefix = sessionInitializationEndpointPrefix;
        }

        public final String getSlateAdUrl() {
            return slateAdUrl;
        }

        @Override
        public final Builder slateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
            return this;
        }

        public final void setSlateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public final String getTranscodeProfileName() {
            return transcodeProfileName;
        }

        @Override
        public final Builder transcodeProfileName(String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
            return this;
        }

        public final void setTranscodeProfileName(String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
        }

        public final String getVideoContentSourceUrl() {
            return videoContentSourceUrl;
        }

        @Override
        public final Builder videoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
            return this;
        }

        public final void setVideoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
        }

        @Override
        public PlaybackConfiguration build() {
            return new PlaybackConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
