/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.OriginManifestType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashConfigurationForPut
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashConfigurationForPut> {
    private static final SdkField<String> MPD_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashConfigurationForPut.getter(DashConfigurationForPut::mpdLocation)).setter(DashConfigurationForPut.setter(Builder::mpdLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MpdLocation").build()}).build();
    private static final SdkField<String> ORIGIN_MANIFEST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DashConfigurationForPut.getter(DashConfigurationForPut::originManifestTypeAsString)).setter(DashConfigurationForPut.setter(Builder::originManifestType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginManifestType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MPD_LOCATION_FIELD, ORIGIN_MANIFEST_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mpdLocation;
    private final String originManifestType;

    private DashConfigurationForPut(BuilderImpl builder) {
        this.mpdLocation = builder.mpdLocation;
        this.originManifestType = builder.originManifestType;
    }

    public String mpdLocation() {
        return this.mpdLocation;
    }

    public OriginManifestType originManifestType() {
        return OriginManifestType.fromValue(this.originManifestType);
    }

    public String originManifestTypeAsString() {
        return this.originManifestType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mpdLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.originManifestTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashConfigurationForPut)) {
            return false;
        }
        DashConfigurationForPut other = (DashConfigurationForPut)obj;
        return Objects.equals(this.mpdLocation(), other.mpdLocation()) && Objects.equals(this.originManifestTypeAsString(), other.originManifestTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DashConfigurationForPut").add("MpdLocation", (Object)this.mpdLocation()).add("OriginManifestType", (Object)this.originManifestTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MpdLocation": {
                return Optional.ofNullable(clazz.cast(this.mpdLocation()));
            }
            case "OriginManifestType": {
                return Optional.ofNullable(clazz.cast(this.originManifestTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashConfigurationForPut, T> g) {
        return obj -> g.apply((DashConfigurationForPut)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mpdLocation;
        private String originManifestType;

        private BuilderImpl() {
        }

        private BuilderImpl(DashConfigurationForPut model) {
            this.mpdLocation(model.mpdLocation);
            this.originManifestType(model.originManifestType);
        }

        public final String getMpdLocation() {
            return this.mpdLocation;
        }

        @Override
        public final Builder mpdLocation(String mpdLocation) {
            this.mpdLocation = mpdLocation;
            return this;
        }

        public final void setMpdLocation(String mpdLocation) {
            this.mpdLocation = mpdLocation;
        }

        public final String getOriginManifestTypeAsString() {
            return this.originManifestType;
        }

        @Override
        public final Builder originManifestType(String originManifestType) {
            this.originManifestType = originManifestType;
            return this;
        }

        @Override
        public final Builder originManifestType(OriginManifestType originManifestType) {
            this.originManifestType(originManifestType == null ? null : originManifestType.toString());
            return this;
        }

        public final void setOriginManifestType(String originManifestType) {
            this.originManifestType = originManifestType;
        }

        public DashConfigurationForPut build() {
            return new DashConfigurationForPut(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashConfigurationForPut> {
        public Builder mpdLocation(String var1);

        public Builder originManifestType(String var1);

        public Builder originManifestType(OriginManifestType var1);
    }
}

