/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubconfig.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubconfig.MigrationHubConfigClient;
import software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest;
import software.amazon.awssdk.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse;

public class DescribeHomeRegionControlsIterable
implements SdkIterable<DescribeHomeRegionControlsResponse> {
    private final MigrationHubConfigClient client;
    private final DescribeHomeRegionControlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeHomeRegionControlsIterable(MigrationHubConfigClient client, DescribeHomeRegionControlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeHomeRegionControlsResponseFetcher();
    }

    public Iterator<DescribeHomeRegionControlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeHomeRegionControlsResponseFetcher
    implements SyncPageFetcher<DescribeHomeRegionControlsResponse> {
        private DescribeHomeRegionControlsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHomeRegionControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeHomeRegionControlsResponse nextPage(DescribeHomeRegionControlsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHomeRegionControlsIterable.this.client.describeHomeRegionControls(DescribeHomeRegionControlsIterable.this.firstRequest);
            }
            return DescribeHomeRegionControlsIterable.this.client.describeHomeRegionControls((DescribeHomeRegionControlsRequest)((Object)DescribeHomeRegionControlsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

