/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mq.model.AuthenticationStrategy;
import software.amazon.awssdk.services.mq.model.ConfigurationRevision;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfigurationResponse
extends MqResponse
implements ToCopyableBuilder<Builder, CreateConfigurationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateConfigurationResponse.getter(CreateConfigurationResponse::arn)).setter(CreateConfigurationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> AUTHENTICATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationStrategy").getter(CreateConfigurationResponse.getter(CreateConfigurationResponse::authenticationStrategyAsString)).setter(CreateConfigurationResponse.setter(Builder::authenticationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationStrategy").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(CreateConfigurationResponse.getter(CreateConfigurationResponse::created)).setter(CreateConfigurationResponse.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateConfigurationResponse.getter(CreateConfigurationResponse::id)).setter(CreateConfigurationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ConfigurationRevision> LATEST_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LatestRevision").getter(CreateConfigurationResponse.getter(CreateConfigurationResponse::latestRevision)).setter(CreateConfigurationResponse.setter(Builder::latestRevision)).constructor(ConfigurationRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestRevision").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateConfigurationResponse.getter(CreateConfigurationResponse::name)).setter(CreateConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTHENTICATION_STRATEGY_FIELD, CREATED_FIELD, ID_FIELD, LATEST_REVISION_FIELD, NAME_FIELD));
    private final String arn;
    private final String authenticationStrategy;
    private final Instant created;
    private final String id;
    private final ConfigurationRevision latestRevision;
    private final String name;

    private CreateConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.authenticationStrategy = builder.authenticationStrategy;
        this.created = builder.created;
        this.id = builder.id;
        this.latestRevision = builder.latestRevision;
        this.name = builder.name;
    }

    public String arn() {
        return this.arn;
    }

    public AuthenticationStrategy authenticationStrategy() {
        return AuthenticationStrategy.fromValue(this.authenticationStrategy);
    }

    public String authenticationStrategyAsString() {
        return this.authenticationStrategy;
    }

    public Instant created() {
        return this.created;
    }

    public String id() {
        return this.id;
    }

    public ConfigurationRevision latestRevision() {
        return this.latestRevision;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationResponse)) {
            return false;
        }
        CreateConfigurationResponse other = (CreateConfigurationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.authenticationStrategyAsString(), other.authenticationStrategyAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.latestRevision(), other.latestRevision()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"CreateConfigurationResponse").add("Arn", (Object)this.arn()).add("AuthenticationStrategy", (Object)this.authenticationStrategyAsString()).add("Created", (Object)this.created()).add("Id", (Object)this.id()).add("LatestRevision", (Object)this.latestRevision()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AuthenticationStrategy": {
                return Optional.ofNullable(clazz.cast(this.authenticationStrategyAsString()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LatestRevision": {
                return Optional.ofNullable(clazz.cast(this.latestRevision()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationResponse, T> g) {
        return obj -> g.apply((CreateConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String authenticationStrategy;
        private Instant created;
        private String id;
        private ConfigurationRevision latestRevision;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationResponse model) {
            super(model);
            this.arn(model.arn);
            this.authenticationStrategy(model.authenticationStrategy);
            this.created(model.created);
            this.id(model.id);
            this.latestRevision(model.latestRevision);
            this.name(model.name);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getAuthenticationStrategy() {
            return this.authenticationStrategy;
        }

        @Override
        public final Builder authenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
            return this;
        }

        @Override
        public final Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy) {
            this.authenticationStrategy(authenticationStrategy == null ? null : authenticationStrategy.toString());
            return this;
        }

        public final void setAuthenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ConfigurationRevision.Builder getLatestRevision() {
            return this.latestRevision != null ? this.latestRevision.toBuilder() : null;
        }

        @Override
        public final Builder latestRevision(ConfigurationRevision latestRevision) {
            this.latestRevision = latestRevision;
            return this;
        }

        public final void setLatestRevision(ConfigurationRevision.BuilderImpl latestRevision) {
            this.latestRevision = latestRevision != null ? latestRevision.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public CreateConfigurationResponse build() {
            return new CreateConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfigurationResponse> {
        public Builder arn(String var1);

        public Builder authenticationStrategy(String var1);

        public Builder authenticationStrategy(AuthenticationStrategy var1);

        public Builder created(Instant var1);

        public Builder id(String var1);

        public Builder latestRevision(ConfigurationRevision var1);

        default public Builder latestRevision(Consumer<ConfigurationRevision.Builder> latestRevision) {
            return this.latestRevision((ConfigurationRevision)((ConfigurationRevision.Builder)ConfigurationRevision.builder().applyMutation(latestRevision)).build());
        }

        public Builder name(String var1);
    }
}

