/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.EventExecutor;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.CancellableAcquireChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.ChannelPipelineInitializer;
import software.amazon.awssdk.http.nio.netty.internal.HandlerRemovingChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.HonorCloseOnReleaseChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import software.amazon.awssdk.http.nio.netty.internal.NettyRequestExecutor;
import software.amazon.awssdk.http.nio.netty.internal.NonManagedEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.ReleaseOnceChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.http.nio.netty.internal.SdkChannelOptions;
import software.amazon.awssdk.http.nio.netty.internal.SdkChannelPoolMap;
import software.amazon.awssdk.http.nio.netty.internal.SharedSdkEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.http2.HttpOrHttp2ChannelPool;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class NettyNioAsyncHttpClient
implements SdkAsyncHttpClient {
    private static final Logger log = LoggerFactory.getLogger(NettyNioAsyncHttpClient.class);
    private static final long MAX_STREAMS_ALLOWED = 0xFFFFFFFFL;
    private final SdkEventLoopGroup sdkEventLoopGroup;
    private final SdkChannelPoolMap<URI, ChannelPool> pools;
    private final SdkChannelOptions sdkChannelOptions;
    private final NettyConfiguration configuration;
    private final long maxStreams;
    private Protocol protocol;

    NettyNioAsyncHttpClient(DefaultBuilder builder, AttributeMap serviceDefaultsMap) {
        this.configuration = new NettyConfiguration(serviceDefaultsMap);
        this.protocol = (Protocol)serviceDefaultsMap.get((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL);
        this.maxStreams = builder.maxHttp2Streams == null ? 0xFFFFFFFFL : (long)builder.maxHttp2Streams.intValue();
        this.sdkEventLoopGroup = this.eventLoopGroup(builder);
        this.pools = this.createChannelPoolMap();
        this.sdkChannelOptions = this.channelOptions(builder);
    }

    @SdkTestInternalApi
    NettyNioAsyncHttpClient(SdkEventLoopGroup sdkEventLoopGroup, SdkChannelPoolMap<URI, ChannelPool> pools, SdkChannelOptions sdkChannelOptions, NettyConfiguration configuration, long maxStreams) {
        this.sdkEventLoopGroup = sdkEventLoopGroup;
        this.pools = pools;
        this.sdkChannelOptions = sdkChannelOptions;
        this.configuration = configuration;
        this.maxStreams = maxStreams;
    }

    public CompletableFuture<Void> execute(AsyncExecuteRequest request) {
        RequestContext ctx = this.createRequestContext(request);
        return new NettyRequestExecutor(ctx).execute();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private SdkChannelOptions channelOptions(DefaultBuilder builder) {
        return builder.sdkChannelOptions;
    }

    private RequestContext createRequestContext(AsyncExecuteRequest request) {
        ChannelPool pool = this.pools.get(NettyNioAsyncHttpClient.poolKey(request.request()));
        return new RequestContext(pool, this.sdkEventLoopGroup.eventLoopGroup(), request, this.configuration);
    }

    private SdkEventLoopGroup eventLoopGroup(DefaultBuilder builder) {
        Validate.isTrue((builder.eventLoopGroup == null || builder.eventLoopGroupBuilder == null ? 1 : 0) != 0, (String)"The eventLoopGroup and the eventLoopGroupFactory can't both be configured.", (Object[])new Object[0]);
        return Either.fromNullable((Object)builder.eventLoopGroup, (Object)builder.eventLoopGroupBuilder).map(e -> (SdkEventLoopGroup)e.map(this::nonManagedEventLoopGroup, SdkEventLoopGroup.Builder::build)).orElseGet(SharedSdkEventLoopGroup::get);
    }

    private static URI poolKey(SdkHttpRequest sdkRequest) {
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(sdkRequest.protocol(), null, sdkRequest.host(), sdkRequest.port(), null, null, null));
    }

    private SslContext sslContext(String protocol) {
        if (!protocol.equalsIgnoreCase("https")) {
            return null;
        }
        try {
            return SslContextBuilder.forClient().sslProvider(SslContext.defaultClientProvider()).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(this.getTrustManager()).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    private TrustManagerFactory getTrustManager() {
        return this.configuration.trustAllCertificates() ? InsecureTrustManagerFactory.INSTANCE : null;
    }

    private SdkChannelPoolMap<URI, ChannelPool> createChannelPoolMap() {
        return new SdkChannelPoolMap<URI, ChannelPool>(){

            @Override
            protected ChannelPool newPool(URI key) {
                SslContext sslContext = NettyNioAsyncHttpClient.this.sslContext(key.getScheme());
                Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(NettyNioAsyncHttpClient.this.sdkEventLoopGroup.eventLoopGroup())).channelFactory(NettyNioAsyncHttpClient.this.sdkEventLoopGroup.channelFactory())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)NettyNioAsyncHttpClient.this.configuration.connectTimeoutMillis())).remoteAddress(key.getHost(), key.getPort());
                NettyNioAsyncHttpClient.this.sdkChannelOptions.channelOptions().forEach((arg_0, arg_1) -> ((Bootstrap)bootstrap).option(arg_0, arg_1));
                AtomicReference<ChannelPool> channelPoolRef = new AtomicReference<ChannelPool>();
                ChannelPipelineInitializer handler = new ChannelPipelineInitializer(NettyNioAsyncHttpClient.this.protocol, sslContext, NettyNioAsyncHttpClient.this.maxStreams, channelPoolRef, NettyNioAsyncHttpClient.this.configuration);
                channelPoolRef.set(NettyNioAsyncHttpClient.this.createChannelPool(bootstrap, handler));
                return channelPoolRef.get();
            }
        };
    }

    private ChannelPool createChannelPool(Bootstrap bootstrap, ChannelPipelineInitializer handler) {
        Object channelPool = new SimpleChannelPool(bootstrap, (ChannelPoolHandler)handler);
        channelPool = new HonorCloseOnReleaseChannelPool((ChannelPool)channelPool);
        channelPool = new HttpOrHttp2ChannelPool((ChannelPool)channelPool, bootstrap.config().group(), this.configuration.maxConnections(), this.configuration);
        channelPool = new HandlerRemovingChannelPool((ChannelPool)channelPool);
        channelPool = new ReleaseOnceChannelPool((ChannelPool)channelPool);
        channelPool = new CancellableAcquireChannelPool((EventExecutor)bootstrap.config().group().next(), (ChannelPool)channelPool);
        return channelPool;
    }

    private SdkEventLoopGroup nonManagedEventLoopGroup(SdkEventLoopGroup eventLoopGroup) {
        return SdkEventLoopGroup.create(new NonManagedEventLoopGroup(eventLoopGroup.eventLoopGroup()), eventLoopGroup.channelFactory());
    }

    public void close() {
        FunctionalUtils.runAndLogError((Logger)log, (String)"Unable to close channel pools", this.pools::close);
        FunctionalUtils.runAndLogError((Logger)log, (String)"Unable to shutdown event loop", () -> this.closeEventLoopUninterruptibly(this.sdkEventLoopGroup.eventLoopGroup()));
    }

    private void closeEventLoopUninterruptibly(EventLoopGroup eventLoopGroup) throws ExecutionException {
        try {
            eventLoopGroup.shutdownGracefully(2L, 15L, TimeUnit.SECONDS).get(16L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(String.format("Shutting down Netty EventLoopGroup did not complete within %s seconds", 16));
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();
        private SdkChannelOptions sdkChannelOptions = new SdkChannelOptions();
        private SdkEventLoopGroup eventLoopGroup;
        private SdkEventLoopGroup.Builder eventLoopGroupBuilder;
        private Integer maxHttp2Streams;

        private DefaultBuilder() {
        }

        @Override
        public Builder maxConcurrency(Integer maxConcurrency) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConcurrency);
            return this;
        }

        public void setMaxConcurrency(Integer maxConnectionsPerEndpoint) {
            this.maxConcurrency(maxConnectionsPerEndpoint);
        }

        @Override
        public Builder maxPendingConnectionAcquires(Integer maxPendingAcquires) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_PENDING_CONNECTION_ACQUIRES, (Object)maxPendingAcquires);
            return this;
        }

        public void setMaxPendingConnectionAcquires(Integer maxPendingAcquires) {
            this.maxPendingConnectionAcquires(maxPendingAcquires);
        }

        @Override
        public Builder readTimeout(Duration readTimeout) {
            Validate.isPositive((Duration)readTimeout, (String)"readTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)readTimeout);
            return this;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout(readTimeout);
        }

        @Override
        public Builder writeTimeout(Duration writeTimeout) {
            Validate.isPositive((Duration)writeTimeout, (String)"writeTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.WRITE_TIMEOUT, (Object)writeTimeout);
            return this;
        }

        public void setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout(writeTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration timeout) {
            Validate.isPositive((Duration)timeout, (String)"connectionTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)timeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        @Override
        public Builder connectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            Validate.isPositive((Duration)connectionAcquisitionTimeout, (String)"connectionAcquisitionTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT, (Object)connectionAcquisitionTimeout);
            return this;
        }

        public void setConnectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            this.connectionAcquisitionTimeout(connectionAcquisitionTimeout);
        }

        @Override
        public Builder connectionTimeToLive(Duration connectionTimeToLive) {
            Validate.isPositive((Duration)connectionTimeToLive, (String)"connectionTimeToLive");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE, (Object)connectionTimeToLive);
            return this;
        }

        public void setConnectionTimeToLive(Duration connectionTimeToLive) {
            this.connectionTimeToLive(connectionTimeToLive);
        }

        @Override
        public Builder connectionMaxIdleTime(Duration connectionMaxIdleTime) {
            Validate.isPositive((Duration)connectionMaxIdleTime, (String)"connectionMaxIdleTime");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT, (Object)connectionMaxIdleTime);
            return this;
        }

        public void setConnectionMaxIdleTime(Duration connectionMaxIdleTime) {
            this.connectionMaxIdleTime(connectionMaxIdleTime);
        }

        @Override
        public Builder useIdleConnectionReaper(Boolean useIdleConnectionReaper) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.REAP_IDLE_CONNECTIONS, (Object)useIdleConnectionReaper);
            return this;
        }

        public void setUseIdleConnectionReaper(Boolean useIdleConnectionReaper) {
            this.useIdleConnectionReaper(useIdleConnectionReaper);
        }

        @Override
        public Builder eventLoopGroup(SdkEventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public void setEventLoopGroup(SdkEventLoopGroup eventLoopGroup) {
            this.eventLoopGroup(eventLoopGroup);
        }

        @Override
        public Builder eventLoopGroupBuilder(SdkEventLoopGroup.Builder eventLoopGroupBuilder) {
            this.eventLoopGroupBuilder = eventLoopGroupBuilder;
            return this;
        }

        public void setEventLoopGroupBuilder(SdkEventLoopGroup.Builder eventLoopGroupBuilder) {
            this.eventLoopGroupBuilder(eventLoopGroupBuilder);
        }

        @Override
        public Builder protocol(Protocol protocol) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL, (Object)protocol);
            return this;
        }

        public void setProtocol(Protocol protocol) {
            this.protocol(protocol);
        }

        @Override
        public Builder putChannelOption(ChannelOption channelOption, Object value) {
            this.sdkChannelOptions.putOption(channelOption, value);
            return this;
        }

        @Override
        public Builder maxHttp2Streams(Integer maxHttp2Streams) {
            this.maxHttp2Streams = maxHttp2Streams;
            return this;
        }

        public void setMaxHttp2Streams(Integer maxHttp2Streams) {
            this.maxHttp2Streams(maxHttp2Streams);
        }

        public SdkAsyncHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new NettyNioAsyncHttpClient(this, this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }
    }

    public static interface Builder
    extends SdkAsyncHttpClient.Builder<Builder> {
        public Builder maxConcurrency(Integer var1);

        public Builder maxPendingConnectionAcquires(Integer var1);

        public Builder readTimeout(Duration var1);

        public Builder writeTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder connectionAcquisitionTimeout(Duration var1);

        public Builder connectionTimeToLive(Duration var1);

        public Builder connectionMaxIdleTime(Duration var1);

        public Builder useIdleConnectionReaper(Boolean var1);

        public Builder eventLoopGroup(SdkEventLoopGroup var1);

        public Builder eventLoopGroupBuilder(SdkEventLoopGroup.Builder var1);

        public Builder protocol(Protocol var1);

        public Builder putChannelOption(ChannelOption var1, Object var2);

        public Builder maxHttp2Streams(Integer var1);
    }
}

