/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LogDestinationType {
    S3("S3"),
    CLOUD_WATCH_LOGS("CloudWatchLogs"),
    KINESIS_DATA_FIREHOSE("KinesisDataFirehose"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LogDestinationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogDestinationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LogDestinationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogDestinationType> knownValues() {
        return Stream.of(LogDestinationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

