/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmonitor;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.networkmonitor.DefaultNetworkMonitorClientBuilder;
import software.amazon.awssdk.services.networkmonitor.NetworkMonitorClientBuilder;
import software.amazon.awssdk.services.networkmonitor.NetworkMonitorServiceClientConfiguration;
import software.amazon.awssdk.services.networkmonitor.model.AccessDeniedException;
import software.amazon.awssdk.services.networkmonitor.model.ConflictException;
import software.amazon.awssdk.services.networkmonitor.model.CreateMonitorRequest;
import software.amazon.awssdk.services.networkmonitor.model.CreateMonitorResponse;
import software.amazon.awssdk.services.networkmonitor.model.CreateProbeRequest;
import software.amazon.awssdk.services.networkmonitor.model.CreateProbeResponse;
import software.amazon.awssdk.services.networkmonitor.model.DeleteMonitorRequest;
import software.amazon.awssdk.services.networkmonitor.model.DeleteMonitorResponse;
import software.amazon.awssdk.services.networkmonitor.model.DeleteProbeRequest;
import software.amazon.awssdk.services.networkmonitor.model.DeleteProbeResponse;
import software.amazon.awssdk.services.networkmonitor.model.GetMonitorRequest;
import software.amazon.awssdk.services.networkmonitor.model.GetMonitorResponse;
import software.amazon.awssdk.services.networkmonitor.model.GetProbeRequest;
import software.amazon.awssdk.services.networkmonitor.model.GetProbeResponse;
import software.amazon.awssdk.services.networkmonitor.model.InternalServerException;
import software.amazon.awssdk.services.networkmonitor.model.ListMonitorsRequest;
import software.amazon.awssdk.services.networkmonitor.model.ListMonitorsResponse;
import software.amazon.awssdk.services.networkmonitor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.networkmonitor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.networkmonitor.model.NetworkMonitorException;
import software.amazon.awssdk.services.networkmonitor.model.ResourceNotFoundException;
import software.amazon.awssdk.services.networkmonitor.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.networkmonitor.model.TagResourceRequest;
import software.amazon.awssdk.services.networkmonitor.model.TagResourceResponse;
import software.amazon.awssdk.services.networkmonitor.model.ThrottlingException;
import software.amazon.awssdk.services.networkmonitor.model.UntagResourceRequest;
import software.amazon.awssdk.services.networkmonitor.model.UntagResourceResponse;
import software.amazon.awssdk.services.networkmonitor.model.UpdateMonitorRequest;
import software.amazon.awssdk.services.networkmonitor.model.UpdateMonitorResponse;
import software.amazon.awssdk.services.networkmonitor.model.UpdateProbeRequest;
import software.amazon.awssdk.services.networkmonitor.model.UpdateProbeResponse;
import software.amazon.awssdk.services.networkmonitor.model.ValidationException;
import software.amazon.awssdk.services.networkmonitor.paginators.ListMonitorsIterable;

@SdkPublicApi
@ThreadSafe
public interface NetworkMonitorClient
extends AwsClient {
    public static final String SERVICE_NAME = "networkmonitor";
    public static final String SERVICE_METADATA_ID = "networkmonitor";

    default public CreateMonitorResponse createMonitor(CreateMonitorRequest createMonitorRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public CreateMonitorResponse createMonitor(Consumer<CreateMonitorRequest.Builder> createMonitorRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.createMonitor((CreateMonitorRequest)((Object)((CreateMonitorRequest.Builder)CreateMonitorRequest.builder().applyMutation(createMonitorRequest)).build()));
    }

    default public CreateProbeResponse createProbe(CreateProbeRequest createProbeRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public CreateProbeResponse createProbe(Consumer<CreateProbeRequest.Builder> createProbeRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.createProbe((CreateProbeRequest)((Object)((CreateProbeRequest.Builder)CreateProbeRequest.builder().applyMutation(createProbeRequest)).build()));
    }

    default public DeleteMonitorResponse deleteMonitor(DeleteMonitorRequest deleteMonitorRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public DeleteMonitorResponse deleteMonitor(Consumer<DeleteMonitorRequest.Builder> deleteMonitorRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.deleteMonitor((DeleteMonitorRequest)((Object)((DeleteMonitorRequest.Builder)DeleteMonitorRequest.builder().applyMutation(deleteMonitorRequest)).build()));
    }

    default public DeleteProbeResponse deleteProbe(DeleteProbeRequest deleteProbeRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public DeleteProbeResponse deleteProbe(Consumer<DeleteProbeRequest.Builder> deleteProbeRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.deleteProbe((DeleteProbeRequest)((Object)((DeleteProbeRequest.Builder)DeleteProbeRequest.builder().applyMutation(deleteProbeRequest)).build()));
    }

    default public GetMonitorResponse getMonitor(GetMonitorRequest getMonitorRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public GetMonitorResponse getMonitor(Consumer<GetMonitorRequest.Builder> getMonitorRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.getMonitor((GetMonitorRequest)((Object)((GetMonitorRequest.Builder)GetMonitorRequest.builder().applyMutation(getMonitorRequest)).build()));
    }

    default public GetProbeResponse getProbe(GetProbeRequest getProbeRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public GetProbeResponse getProbe(Consumer<GetProbeRequest.Builder> getProbeRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.getProbe((GetProbeRequest)((Object)((GetProbeRequest.Builder)GetProbeRequest.builder().applyMutation(getProbeRequest)).build()));
    }

    default public ListMonitorsResponse listMonitors(ListMonitorsRequest listMonitorsRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public ListMonitorsResponse listMonitors(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.listMonitors((ListMonitorsRequest)((Object)((ListMonitorsRequest.Builder)ListMonitorsRequest.builder().applyMutation(listMonitorsRequest)).build()));
    }

    default public ListMonitorsIterable listMonitorsPaginator(ListMonitorsRequest listMonitorsRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return new ListMonitorsIterable(this, listMonitorsRequest);
    }

    default public ListMonitorsIterable listMonitorsPaginator(Consumer<ListMonitorsRequest.Builder> listMonitorsRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.listMonitorsPaginator((ListMonitorsRequest)((Object)((ListMonitorsRequest.Builder)ListMonitorsRequest.builder().applyMutation(listMonitorsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateMonitorResponse updateMonitor(UpdateMonitorRequest updateMonitorRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public UpdateMonitorResponse updateMonitor(Consumer<UpdateMonitorRequest.Builder> updateMonitorRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.updateMonitor((UpdateMonitorRequest)((Object)((UpdateMonitorRequest.Builder)UpdateMonitorRequest.builder().applyMutation(updateMonitorRequest)).build()));
    }

    default public UpdateProbeResponse updateProbe(UpdateProbeRequest updateProbeRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NetworkMonitorException {
        throw new UnsupportedOperationException();
    }

    default public UpdateProbeResponse updateProbe(Consumer<UpdateProbeRequest.Builder> updateProbeRequest) throws AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NetworkMonitorException {
        return this.updateProbe((UpdateProbeRequest)((Object)((UpdateProbeRequest.Builder)UpdateProbeRequest.builder().applyMutation(updateProbeRequest)).build()));
    }

    public static NetworkMonitorClient create() {
        return (NetworkMonitorClient)NetworkMonitorClient.builder().build();
    }

    public static NetworkMonitorClientBuilder builder() {
        return new DefaultNetworkMonitorClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"networkmonitor");
    }

    default public NetworkMonitorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

