/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.NimbleResponse;
import software.amazon.awssdk.services.nimble.model.StreamingSession;
import software.amazon.awssdk.services.nimble.model.StreamingSessionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamingSessionsResponse
extends NimbleResponse
implements ToCopyableBuilder<Builder, ListStreamingSessionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStreamingSessionsResponse.getter(ListStreamingSessionsResponse::nextToken)).setter(ListStreamingSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<StreamingSession>> SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sessions").getter(ListStreamingSessionsResponse.getter(ListStreamingSessionsResponse::sessions)).setter(ListStreamingSessionsResponse.setter(Builder::sessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamingSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SESSIONS_FIELD));
    private final String nextToken;
    private final List<StreamingSession> sessions;

    private ListStreamingSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sessions = builder.sessions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSessions() {
        return this.sessions != null && !(this.sessions instanceof SdkAutoConstructList);
    }

    public final List<StreamingSession> sessions() {
        return this.sessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessions() ? this.sessions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamingSessionsResponse)) {
            return false;
        }
        ListStreamingSessionsResponse other = (ListStreamingSessionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSessions() == other.hasSessions() && Objects.equals(this.sessions(), other.sessions());
    }

    public final String toString() {
        return ToString.builder((String)"ListStreamingSessionsResponse").add("NextToken", (Object)this.nextToken()).add("Sessions", this.hasSessions() ? this.sessions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sessions": {
                return Optional.ofNullable(clazz.cast(this.sessions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamingSessionsResponse, T> g) {
        return obj -> g.apply((ListStreamingSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StreamingSession> sessions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamingSessionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.sessions(model.sessions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StreamingSession.Builder> getSessions() {
            List<StreamingSession.Builder> result = StreamingSessionListCopier.copyToBuilder(this.sessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessions(Collection<StreamingSession.BuilderImpl> sessions) {
            this.sessions = StreamingSessionListCopier.copyFromBuilder(sessions);
        }

        @Override
        @Transient
        public final Builder sessions(Collection<StreamingSession> sessions) {
            this.sessions = StreamingSessionListCopier.copy(sessions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sessions(StreamingSession ... sessions) {
            this.sessions(Arrays.asList(sessions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sessions(Consumer<StreamingSession.Builder> ... sessions) {
            this.sessions(Stream.of(sessions).map(c -> (StreamingSession)((StreamingSession.Builder)StreamingSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStreamingSessionsResponse build() {
            return new ListStreamingSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamingSessionsResponse> {
        public Builder nextToken(String var1);

        public Builder sessions(Collection<StreamingSession> var1);

        public Builder sessions(StreamingSession ... var1);

        public Builder sessions(Consumer<StreamingSession.Builder> ... var1);
    }
}

