/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.NimbleResponse;
import software.amazon.awssdk.services.nimble.model.StudioMembership;
import software.amazon.awssdk.services.nimble.model.StudioMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStudioMembersResponse
extends NimbleResponse
implements ToCopyableBuilder<Builder, ListStudioMembersResponse> {
    private static final SdkField<List<StudioMembership>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("members").getter(ListStudioMembersResponse.getter(ListStudioMembersResponse::members)).setter(ListStudioMembersResponse.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StudioMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStudioMembersResponse.getter(ListStudioMembersResponse::nextToken)).setter(ListStudioMembersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<StudioMembership> members;
    private final String nextToken;

    private ListStudioMembersResponse(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<StudioMembership> members() {
        return this.members;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudioMembersResponse)) {
            return false;
        }
        ListStudioMembersResponse other = (ListStudioMembersResponse)((Object)obj);
        return this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStudioMembersResponse").add("Members", this.hasMembers() ? this.members() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStudioMembersResponse, T> g) {
        return obj -> g.apply((ListStudioMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleResponse.BuilderImpl
    implements Builder {
        private List<StudioMembership> members = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudioMembersResponse model) {
            super(model);
            this.members(model.members);
            this.nextToken(model.nextToken);
        }

        public final List<StudioMembership.Builder> getMembers() {
            List<StudioMembership.Builder> result = StudioMembershipListCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<StudioMembership.BuilderImpl> members) {
            this.members = StudioMembershipListCopier.copyFromBuilder(members);
        }

        @Override
        @Transient
        public final Builder members(Collection<StudioMembership> members) {
            this.members = StudioMembershipListCopier.copy(members);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder members(StudioMembership ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder members(Consumer<StudioMembership.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (StudioMembership)((StudioMembership.Builder)StudioMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStudioMembersResponse build() {
            return new ListStudioMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStudioMembersResponse> {
        public Builder members(Collection<StudioMembership> var1);

        public Builder members(StudioMembership ... var1);

        public Builder members(Consumer<StudioMembership.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

