/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SharedFileSystemConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SharedFileSystemConfiguration> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(SharedFileSystemConfiguration.getter(SharedFileSystemConfiguration::endpoint)).setter(SharedFileSystemConfiguration.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileSystemId").getter(SharedFileSystemConfiguration.getter(SharedFileSystemConfiguration::fileSystemId)).setter(SharedFileSystemConfiguration.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemId").build()}).build();
    private static final SdkField<String> LINUX_MOUNT_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("linuxMountPoint").getter(SharedFileSystemConfiguration.getter(SharedFileSystemConfiguration::linuxMountPoint)).setter(SharedFileSystemConfiguration.setter(Builder::linuxMountPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linuxMountPoint").build()}).build();
    private static final SdkField<String> SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareName").getter(SharedFileSystemConfiguration.getter(SharedFileSystemConfiguration::shareName)).setter(SharedFileSystemConfiguration.setter(Builder::shareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareName").build()}).build();
    private static final SdkField<String> WINDOWS_MOUNT_DRIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("windowsMountDrive").getter(SharedFileSystemConfiguration.getter(SharedFileSystemConfiguration::windowsMountDrive)).setter(SharedFileSystemConfiguration.setter(Builder::windowsMountDrive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("windowsMountDrive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD, FILE_SYSTEM_ID_FIELD, LINUX_MOUNT_POINT_FIELD, SHARE_NAME_FIELD, WINDOWS_MOUNT_DRIVE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpoint;
    private final String fileSystemId;
    private final String linuxMountPoint;
    private final String shareName;
    private final String windowsMountDrive;

    private SharedFileSystemConfiguration(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.fileSystemId = builder.fileSystemId;
        this.linuxMountPoint = builder.linuxMountPoint;
        this.shareName = builder.shareName;
        this.windowsMountDrive = builder.windowsMountDrive;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String linuxMountPoint() {
        return this.linuxMountPoint;
    }

    public final String shareName() {
        return this.shareName;
    }

    public final String windowsMountDrive() {
        return this.windowsMountDrive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.linuxMountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareName());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowsMountDrive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharedFileSystemConfiguration)) {
            return false;
        }
        SharedFileSystemConfiguration other = (SharedFileSystemConfiguration)obj;
        return Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.linuxMountPoint(), other.linuxMountPoint()) && Objects.equals(this.shareName(), other.shareName()) && Objects.equals(this.windowsMountDrive(), other.windowsMountDrive());
    }

    public final String toString() {
        return ToString.builder((String)"SharedFileSystemConfiguration").add("Endpoint", (Object)this.endpoint()).add("FileSystemId", (Object)this.fileSystemId()).add("LinuxMountPoint", (Object)this.linuxMountPoint()).add("ShareName", (Object)this.shareName()).add("WindowsMountDrive", (Object)this.windowsMountDrive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "fileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "linuxMountPoint": {
                return Optional.ofNullable(clazz.cast(this.linuxMountPoint()));
            }
            case "shareName": {
                return Optional.ofNullable(clazz.cast(this.shareName()));
            }
            case "windowsMountDrive": {
                return Optional.ofNullable(clazz.cast(this.windowsMountDrive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SharedFileSystemConfiguration, T> g) {
        return obj -> g.apply((SharedFileSystemConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpoint;
        private String fileSystemId;
        private String linuxMountPoint;
        private String shareName;
        private String windowsMountDrive;

        private BuilderImpl() {
        }

        private BuilderImpl(SharedFileSystemConfiguration model) {
            this.endpoint(model.endpoint);
            this.fileSystemId(model.fileSystemId);
            this.linuxMountPoint(model.linuxMountPoint);
            this.shareName(model.shareName);
            this.windowsMountDrive(model.windowsMountDrive);
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Transient
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getLinuxMountPoint() {
            return this.linuxMountPoint;
        }

        public final void setLinuxMountPoint(String linuxMountPoint) {
            this.linuxMountPoint = linuxMountPoint;
        }

        @Override
        @Transient
        public final Builder linuxMountPoint(String linuxMountPoint) {
            this.linuxMountPoint = linuxMountPoint;
            return this;
        }

        public final String getShareName() {
            return this.shareName;
        }

        public final void setShareName(String shareName) {
            this.shareName = shareName;
        }

        @Override
        @Transient
        public final Builder shareName(String shareName) {
            this.shareName = shareName;
            return this;
        }

        public final String getWindowsMountDrive() {
            return this.windowsMountDrive;
        }

        public final void setWindowsMountDrive(String windowsMountDrive) {
            this.windowsMountDrive = windowsMountDrive;
        }

        @Override
        @Transient
        public final Builder windowsMountDrive(String windowsMountDrive) {
            this.windowsMountDrive = windowsMountDrive;
            return this;
        }

        public SharedFileSystemConfiguration build() {
            return new SharedFileSystemConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SharedFileSystemConfiguration> {
        public Builder endpoint(String var1);

        public Builder fileSystemId(String var1);

        public Builder linuxMountPoint(String var1);

        public Builder shareName(String var1);

        public Builder windowsMountDrive(String var1);
    }
}

