/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StreamingSessionStatusCode {
    STREAMING_SESSION_READY("STREAMING_SESSION_READY"),
    STREAMING_SESSION_DELETED("STREAMING_SESSION_DELETED"),
    STREAMING_SESSION_CREATE_IN_PROGRESS("STREAMING_SESSION_CREATE_IN_PROGRESS"),
    STREAMING_SESSION_DELETE_IN_PROGRESS("STREAMING_SESSION_DELETE_IN_PROGRESS"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    INSUFFICIENT_CAPACITY("INSUFFICIENT_CAPACITY"),
    ACTIVE_DIRECTORY_DOMAIN_JOIN_ERROR("ACTIVE_DIRECTORY_DOMAIN_JOIN_ERROR"),
    NETWORK_CONNECTION_ERROR("NETWORK_CONNECTION_ERROR"),
    INITIALIZATION_SCRIPT_ERROR("INITIALIZATION_SCRIPT_ERROR"),
    DECRYPT_STREAMING_IMAGE_ERROR("DECRYPT_STREAMING_IMAGE_ERROR"),
    NETWORK_INTERFACE_ERROR("NETWORK_INTERFACE_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StreamingSessionStatusCode> VALUE_MAP;
    private final String value;

    private StreamingSessionStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StreamingSessionStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StreamingSessionStatusCode> knownValues() {
        EnumSet<StreamingSessionStatusCode> knownValues = EnumSet.allOf(StreamingSessionStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StreamingSessionStatusCode.class, StreamingSessionStatusCode::toString);
    }
}

