/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration;
import software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration;
import software.amazon.awssdk.services.nimble.model.LicenseServiceConfiguration;
import software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StudioComponentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StudioComponentConfiguration> {
    private static final SdkField<ActiveDirectoryConfiguration> ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("activeDirectoryConfiguration").getter(StudioComponentConfiguration.getter(StudioComponentConfiguration::activeDirectoryConfiguration)).setter(StudioComponentConfiguration.setter(Builder::activeDirectoryConfiguration)).constructor(ActiveDirectoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeDirectoryConfiguration").build()}).build();
    private static final SdkField<ComputeFarmConfiguration> COMPUTE_FARM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeFarmConfiguration").getter(StudioComponentConfiguration.getter(StudioComponentConfiguration::computeFarmConfiguration)).setter(StudioComponentConfiguration.setter(Builder::computeFarmConfiguration)).constructor(ComputeFarmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeFarmConfiguration").build()}).build();
    private static final SdkField<LicenseServiceConfiguration> LICENSE_SERVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("licenseServiceConfiguration").getter(StudioComponentConfiguration.getter(StudioComponentConfiguration::licenseServiceConfiguration)).setter(StudioComponentConfiguration.setter(Builder::licenseServiceConfiguration)).constructor(LicenseServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseServiceConfiguration").build()}).build();
    private static final SdkField<SharedFileSystemConfiguration> SHARED_FILE_SYSTEM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sharedFileSystemConfiguration").getter(StudioComponentConfiguration.getter(StudioComponentConfiguration::sharedFileSystemConfiguration)).setter(StudioComponentConfiguration.setter(Builder::sharedFileSystemConfiguration)).constructor(SharedFileSystemConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedFileSystemConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_CONFIGURATION_FIELD, COMPUTE_FARM_CONFIGURATION_FIELD, LICENSE_SERVICE_CONFIGURATION_FIELD, SHARED_FILE_SYSTEM_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ActiveDirectoryConfiguration activeDirectoryConfiguration;
    private final ComputeFarmConfiguration computeFarmConfiguration;
    private final LicenseServiceConfiguration licenseServiceConfiguration;
    private final SharedFileSystemConfiguration sharedFileSystemConfiguration;

    private StudioComponentConfiguration(BuilderImpl builder) {
        this.activeDirectoryConfiguration = builder.activeDirectoryConfiguration;
        this.computeFarmConfiguration = builder.computeFarmConfiguration;
        this.licenseServiceConfiguration = builder.licenseServiceConfiguration;
        this.sharedFileSystemConfiguration = builder.sharedFileSystemConfiguration;
    }

    public final ActiveDirectoryConfiguration activeDirectoryConfiguration() {
        return this.activeDirectoryConfiguration;
    }

    public final ComputeFarmConfiguration computeFarmConfiguration() {
        return this.computeFarmConfiguration;
    }

    public final LicenseServiceConfiguration licenseServiceConfiguration() {
        return this.licenseServiceConfiguration;
    }

    public final SharedFileSystemConfiguration sharedFileSystemConfiguration() {
        return this.sharedFileSystemConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeFarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseServiceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedFileSystemConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StudioComponentConfiguration)) {
            return false;
        }
        StudioComponentConfiguration other = (StudioComponentConfiguration)obj;
        return Objects.equals(this.activeDirectoryConfiguration(), other.activeDirectoryConfiguration()) && Objects.equals(this.computeFarmConfiguration(), other.computeFarmConfiguration()) && Objects.equals(this.licenseServiceConfiguration(), other.licenseServiceConfiguration()) && Objects.equals(this.sharedFileSystemConfiguration(), other.sharedFileSystemConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StudioComponentConfiguration").add("ActiveDirectoryConfiguration", (Object)this.activeDirectoryConfiguration()).add("ComputeFarmConfiguration", (Object)this.computeFarmConfiguration()).add("LicenseServiceConfiguration", (Object)this.licenseServiceConfiguration()).add("SharedFileSystemConfiguration", (Object)this.sharedFileSystemConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeDirectoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.activeDirectoryConfiguration()));
            }
            case "computeFarmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.computeFarmConfiguration()));
            }
            case "licenseServiceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.licenseServiceConfiguration()));
            }
            case "sharedFileSystemConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sharedFileSystemConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StudioComponentConfiguration, T> g) {
        return obj -> g.apply((StudioComponentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActiveDirectoryConfiguration activeDirectoryConfiguration;
        private ComputeFarmConfiguration computeFarmConfiguration;
        private LicenseServiceConfiguration licenseServiceConfiguration;
        private SharedFileSystemConfiguration sharedFileSystemConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StudioComponentConfiguration model) {
            this.activeDirectoryConfiguration(model.activeDirectoryConfiguration);
            this.computeFarmConfiguration(model.computeFarmConfiguration);
            this.licenseServiceConfiguration(model.licenseServiceConfiguration);
            this.sharedFileSystemConfiguration(model.sharedFileSystemConfiguration);
        }

        public final ActiveDirectoryConfiguration.Builder getActiveDirectoryConfiguration() {
            return this.activeDirectoryConfiguration != null ? this.activeDirectoryConfiguration.toBuilder() : null;
        }

        public final void setActiveDirectoryConfiguration(ActiveDirectoryConfiguration.BuilderImpl activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration != null ? activeDirectoryConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder activeDirectoryConfiguration(ActiveDirectoryConfiguration activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration;
            return this;
        }

        public final ComputeFarmConfiguration.Builder getComputeFarmConfiguration() {
            return this.computeFarmConfiguration != null ? this.computeFarmConfiguration.toBuilder() : null;
        }

        public final void setComputeFarmConfiguration(ComputeFarmConfiguration.BuilderImpl computeFarmConfiguration) {
            this.computeFarmConfiguration = computeFarmConfiguration != null ? computeFarmConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder computeFarmConfiguration(ComputeFarmConfiguration computeFarmConfiguration) {
            this.computeFarmConfiguration = computeFarmConfiguration;
            return this;
        }

        public final LicenseServiceConfiguration.Builder getLicenseServiceConfiguration() {
            return this.licenseServiceConfiguration != null ? this.licenseServiceConfiguration.toBuilder() : null;
        }

        public final void setLicenseServiceConfiguration(LicenseServiceConfiguration.BuilderImpl licenseServiceConfiguration) {
            this.licenseServiceConfiguration = licenseServiceConfiguration != null ? licenseServiceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder licenseServiceConfiguration(LicenseServiceConfiguration licenseServiceConfiguration) {
            this.licenseServiceConfiguration = licenseServiceConfiguration;
            return this;
        }

        public final SharedFileSystemConfiguration.Builder getSharedFileSystemConfiguration() {
            return this.sharedFileSystemConfiguration != null ? this.sharedFileSystemConfiguration.toBuilder() : null;
        }

        public final void setSharedFileSystemConfiguration(SharedFileSystemConfiguration.BuilderImpl sharedFileSystemConfiguration) {
            this.sharedFileSystemConfiguration = sharedFileSystemConfiguration != null ? sharedFileSystemConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder sharedFileSystemConfiguration(SharedFileSystemConfiguration sharedFileSystemConfiguration) {
            this.sharedFileSystemConfiguration = sharedFileSystemConfiguration;
            return this;
        }

        public StudioComponentConfiguration build() {
            return new StudioComponentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StudioComponentConfiguration> {
        public Builder activeDirectoryConfiguration(ActiveDirectoryConfiguration var1);

        default public Builder activeDirectoryConfiguration(Consumer<ActiveDirectoryConfiguration.Builder> activeDirectoryConfiguration) {
            return this.activeDirectoryConfiguration((ActiveDirectoryConfiguration)((ActiveDirectoryConfiguration.Builder)ActiveDirectoryConfiguration.builder().applyMutation(activeDirectoryConfiguration)).build());
        }

        public Builder computeFarmConfiguration(ComputeFarmConfiguration var1);

        default public Builder computeFarmConfiguration(Consumer<ComputeFarmConfiguration.Builder> computeFarmConfiguration) {
            return this.computeFarmConfiguration((ComputeFarmConfiguration)((ComputeFarmConfiguration.Builder)ComputeFarmConfiguration.builder().applyMutation(computeFarmConfiguration)).build());
        }

        public Builder licenseServiceConfiguration(LicenseServiceConfiguration var1);

        default public Builder licenseServiceConfiguration(Consumer<LicenseServiceConfiguration.Builder> licenseServiceConfiguration) {
            return this.licenseServiceConfiguration((LicenseServiceConfiguration)((LicenseServiceConfiguration.Builder)LicenseServiceConfiguration.builder().applyMutation(licenseServiceConfiguration)).build());
        }

        public Builder sharedFileSystemConfiguration(SharedFileSystemConfiguration var1);

        default public Builder sharedFileSystemConfiguration(Consumer<SharedFileSystemConfiguration.Builder> sharedFileSystemConfiguration) {
            return this.sharedFileSystemConfiguration((SharedFileSystemConfiguration)((SharedFileSystemConfiguration.Builder)SharedFileSystemConfiguration.builder().applyMutation(sharedFileSystemConfiguration)).build());
        }
    }
}

