/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest;
import software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse;
import software.amazon.awssdk.services.nimble.model.StudioMembership;

public class ListStudioMembersIterable
implements SdkIterable<ListStudioMembersResponse> {
    private final NimbleClient client;
    private final ListStudioMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStudioMembersIterable(NimbleClient client, ListStudioMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStudioMembersResponseFetcher();
    }

    public Iterator<ListStudioMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StudioMembership> members() {
        Function<ListStudioMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStudioMembersResponseFetcher
    implements SyncPageFetcher<ListStudioMembersResponse> {
        private ListStudioMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListStudioMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStudioMembersResponse nextPage(ListStudioMembersResponse previousPage) {
            if (previousPage == null) {
                return ListStudioMembersIterable.this.client.listStudioMembers(ListStudioMembersIterable.this.firstRequest);
            }
            return ListStudioMembersIterable.this.client.listStudioMembers((ListStudioMembersRequest)((Object)ListStudioMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

