/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The maximum capacity limits for all OpenSearch Serverless collections, in OpenSearch Compute Units (OCUs). These
 * limits are used to scale your collections based on the current workload. For more information, see <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html">Managing capacity
 * limits for Amazon OpenSearch Serverless</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityLimits implements SdkPojo, Serializable, ToCopyableBuilder<CapacityLimits.Builder, CapacityLimits> {
    private static final SdkField<Integer> MAX_INDEXING_CAPACITY_IN_OCU_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("maxIndexingCapacityInOCU")
            .getter(getter(CapacityLimits::maxIndexingCapacityInOCU)).setter(setter(Builder::maxIndexingCapacityInOCU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxIndexingCapacityInOCU").build())
            .build();

    private static final SdkField<Integer> MAX_SEARCH_CAPACITY_IN_OCU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxSearchCapacityInOCU").getter(getter(CapacityLimits::maxSearchCapacityInOCU))
            .setter(setter(Builder::maxSearchCapacityInOCU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSearchCapacityInOCU").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_INDEXING_CAPACITY_IN_OCU_FIELD, MAX_SEARCH_CAPACITY_IN_OCU_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxIndexingCapacityInOCU;

    private final Integer maxSearchCapacityInOCU;

    private CapacityLimits(BuilderImpl builder) {
        this.maxIndexingCapacityInOCU = builder.maxIndexingCapacityInOCU;
        this.maxSearchCapacityInOCU = builder.maxSearchCapacityInOCU;
    }

    /**
     * <p>
     * The maximum indexing capacity for collections.
     * </p>
     * 
     * @return The maximum indexing capacity for collections.
     */
    public final Integer maxIndexingCapacityInOCU() {
        return maxIndexingCapacityInOCU;
    }

    /**
     * <p>
     * The maximum search capacity for collections.
     * </p>
     * 
     * @return The maximum search capacity for collections.
     */
    public final Integer maxSearchCapacityInOCU() {
        return maxSearchCapacityInOCU;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxIndexingCapacityInOCU());
        hashCode = 31 * hashCode + Objects.hashCode(maxSearchCapacityInOCU());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityLimits)) {
            return false;
        }
        CapacityLimits other = (CapacityLimits) obj;
        return Objects.equals(maxIndexingCapacityInOCU(), other.maxIndexingCapacityInOCU())
                && Objects.equals(maxSearchCapacityInOCU(), other.maxSearchCapacityInOCU());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityLimits").add("MaxIndexingCapacityInOCU", maxIndexingCapacityInOCU())
                .add("MaxSearchCapacityInOCU", maxSearchCapacityInOCU()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxIndexingCapacityInOCU":
            return Optional.ofNullable(clazz.cast(maxIndexingCapacityInOCU()));
        case "maxSearchCapacityInOCU":
            return Optional.ofNullable(clazz.cast(maxSearchCapacityInOCU()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityLimits, T> g) {
        return obj -> g.apply((CapacityLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityLimits> {
        /**
         * <p>
         * The maximum indexing capacity for collections.
         * </p>
         * 
         * @param maxIndexingCapacityInOCU
         *        The maximum indexing capacity for collections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxIndexingCapacityInOCU(Integer maxIndexingCapacityInOCU);

        /**
         * <p>
         * The maximum search capacity for collections.
         * </p>
         * 
         * @param maxSearchCapacityInOCU
         *        The maximum search capacity for collections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSearchCapacityInOCU(Integer maxSearchCapacityInOCU);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxIndexingCapacityInOCU;

        private Integer maxSearchCapacityInOCU;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityLimits model) {
            maxIndexingCapacityInOCU(model.maxIndexingCapacityInOCU);
            maxSearchCapacityInOCU(model.maxSearchCapacityInOCU);
        }

        public final Integer getMaxIndexingCapacityInOCU() {
            return maxIndexingCapacityInOCU;
        }

        public final void setMaxIndexingCapacityInOCU(Integer maxIndexingCapacityInOCU) {
            this.maxIndexingCapacityInOCU = maxIndexingCapacityInOCU;
        }

        @Override
        public final Builder maxIndexingCapacityInOCU(Integer maxIndexingCapacityInOCU) {
            this.maxIndexingCapacityInOCU = maxIndexingCapacityInOCU;
            return this;
        }

        public final Integer getMaxSearchCapacityInOCU() {
            return maxSearchCapacityInOCU;
        }

        public final void setMaxSearchCapacityInOCU(Integer maxSearchCapacityInOCU) {
            this.maxSearchCapacityInOCU = maxSearchCapacityInOCU;
        }

        @Override
        public final Builder maxSearchCapacityInOCU(Integer maxSearchCapacityInOCU) {
            this.maxSearchCapacityInOCU = maxSearchCapacityInOCU;
            return this;
        }

        @Override
        public CapacityLimits build() {
            return new CapacityLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
