/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityConfigRequest extends OpenSearchServerlessRequest implements
        ToCopyableBuilder<UpdateSecurityConfigRequest.Builder, UpdateSecurityConfigRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateSecurityConfigRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONFIG_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configVersion").getter(getter(UpdateSecurityConfigRequest::configVersion))
            .setter(setter(Builder::configVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateSecurityConfigRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateSecurityConfigRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<SamlConfigOptions> SAML_OPTIONS_FIELD = SdkField
            .<SamlConfigOptions> builder(MarshallingType.SDK_POJO).memberName("samlOptions")
            .getter(getter(UpdateSecurityConfigRequest::samlOptions)).setter(setter(Builder::samlOptions))
            .constructor(SamlConfigOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CONFIG_VERSION_FIELD, DESCRIPTION_FIELD, ID_FIELD, SAML_OPTIONS_FIELD));

    private final String clientToken;

    private final String configVersion;

    private final String description;

    private final String id;

    private final SamlConfigOptions samlOptions;

    private UpdateSecurityConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.configVersion = builder.configVersion;
        this.description = builder.description;
        this.id = builder.id;
        this.samlOptions = builder.samlOptions;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The version of the security configuration to be updated. You can find the most recent version of a security
     * configuration using the <code>GetSecurityPolicy</code> command.
     * </p>
     * 
     * @return The version of the security configuration to be updated. You can find the most recent version of a
     *         security configuration using the <code>GetSecurityPolicy</code> command.
     */
    public final String configVersion() {
        return configVersion;
    }

    /**
     * <p>
     * A description of the security configuration.
     * </p>
     * 
     * @return A description of the security configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The security configuration identifier. For SAML the ID will be
     * <code>saml/&lt;accountId&gt;/&lt;idpProviderName&gt;</code>. For example, <code>saml/123456789123/OKTADev</code>.
     * </p>
     * 
     * @return The security configuration identifier. For SAML the ID will be
     *         <code>saml/&lt;accountId&gt;/&lt;idpProviderName&gt;</code>. For example,
     *         <code>saml/123456789123/OKTADev</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * SAML options in in the form of a key-value map.
     * </p>
     * 
     * @return SAML options in in the form of a key-value map.
     */
    public final SamlConfigOptions samlOptions() {
        return samlOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(configVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(samlOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityConfigRequest)) {
            return false;
        }
        UpdateSecurityConfigRequest other = (UpdateSecurityConfigRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(configVersion(), other.configVersion())
                && Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(samlOptions(), other.samlOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecurityConfigRequest").add("ClientToken", clientToken())
                .add("ConfigVersion", configVersion()).add("Description", description()).add("Id", id())
                .add("SamlOptions", samlOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "configVersion":
            return Optional.ofNullable(clazz.cast(configVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "samlOptions":
            return Optional.ofNullable(clazz.cast(samlOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityConfigRequest, T> g) {
        return obj -> g.apply((UpdateSecurityConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSecurityConfigRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The version of the security configuration to be updated. You can find the most recent version of a security
         * configuration using the <code>GetSecurityPolicy</code> command.
         * </p>
         * 
         * @param configVersion
         *        The version of the security configuration to be updated. You can find the most recent version of a
         *        security configuration using the <code>GetSecurityPolicy</code> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configVersion(String configVersion);

        /**
         * <p>
         * A description of the security configuration.
         * </p>
         * 
         * @param description
         *        A description of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The security configuration identifier. For SAML the ID will be
         * <code>saml/&lt;accountId&gt;/&lt;idpProviderName&gt;</code>. For example,
         * <code>saml/123456789123/OKTADev</code>.
         * </p>
         * 
         * @param id
         *        The security configuration identifier. For SAML the ID will be
         *        <code>saml/&lt;accountId&gt;/&lt;idpProviderName&gt;</code>. For example,
         *        <code>saml/123456789123/OKTADev</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * SAML options in in the form of a key-value map.
         * </p>
         * 
         * @param samlOptions
         *        SAML options in in the form of a key-value map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlOptions(SamlConfigOptions samlOptions);

        /**
         * <p>
         * SAML options in in the form of a key-value map.
         * </p>
         * This is a convenience method that creates an instance of the {@link SamlConfigOptions.Builder} avoiding the
         * need to create one manually via {@link SamlConfigOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SamlConfigOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #samlOptions(SamlConfigOptions)}.
         * 
         * @param samlOptions
         *        a consumer that will call methods on {@link SamlConfigOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samlOptions(SamlConfigOptions)
         */
        default Builder samlOptions(Consumer<SamlConfigOptions.Builder> samlOptions) {
            return samlOptions(SamlConfigOptions.builder().applyMutation(samlOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchServerlessRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String configVersion;

        private String description;

        private String id;

        private SamlConfigOptions samlOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityConfigRequest model) {
            super(model);
            clientToken(model.clientToken);
            configVersion(model.configVersion);
            description(model.description);
            id(model.id);
            samlOptions(model.samlOptions);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConfigVersion() {
            return configVersion;
        }

        public final void setConfigVersion(String configVersion) {
            this.configVersion = configVersion;
        }

        @Override
        public final Builder configVersion(String configVersion) {
            this.configVersion = configVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final SamlConfigOptions.Builder getSamlOptions() {
            return samlOptions != null ? samlOptions.toBuilder() : null;
        }

        public final void setSamlOptions(SamlConfigOptions.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        @Override
        public final Builder samlOptions(SamlConfigOptions samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityConfigRequest build() {
            return new UpdateSecurityConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
