/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the lifecycle event configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecycleEventConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecycleEventConfiguration.Builder, LifecycleEventConfiguration> {
    private static final SdkField<ShutdownEventConfiguration> SHUTDOWN_FIELD = SdkField
            .<ShutdownEventConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(LifecycleEventConfiguration::shutdown))
            .setter(setter(Builder::shutdown)).constructor(ShutdownEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shutdown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHUTDOWN_FIELD));

    private static final long serialVersionUID = 1L;

    private final ShutdownEventConfiguration shutdown;

    private LifecycleEventConfiguration(BuilderImpl builder) {
        this.shutdown = builder.shutdown;
    }

    /**
     * <p>
     * A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event configuration.
     * </p>
     * 
     * @return A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event configuration.
     */
    public ShutdownEventConfiguration shutdown() {
        return shutdown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shutdown());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleEventConfiguration)) {
            return false;
        }
        LifecycleEventConfiguration other = (LifecycleEventConfiguration) obj;
        return Objects.equals(shutdown(), other.shutdown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LifecycleEventConfiguration").add("Shutdown", shutdown()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Shutdown":
            return Optional.ofNullable(clazz.cast(shutdown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecycleEventConfiguration, T> g) {
        return obj -> g.apply((LifecycleEventConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecycleEventConfiguration> {
        /**
         * <p>
         * A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event configuration.
         * </p>
         * 
         * @param shutdown
         *        A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shutdown(ShutdownEventConfiguration shutdown);

        /**
         * <p>
         * A <code>ShutdownEventConfiguration</code> object that specifies the Shutdown event configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ShutdownEventConfiguration.Builder} avoiding the
         * need to create one manually via {@link ShutdownEventConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ShutdownEventConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #shutdown(ShutdownEventConfiguration)}.
         * 
         * @param shutdown
         *        a consumer that will call methods on {@link ShutdownEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shutdown(ShutdownEventConfiguration)
         */
        default Builder shutdown(Consumer<ShutdownEventConfiguration.Builder> shutdown) {
            return shutdown(ShutdownEventConfiguration.builder().applyMutation(shutdown).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ShutdownEventConfiguration shutdown;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleEventConfiguration model) {
            shutdown(model.shutdown);
        }

        public final ShutdownEventConfiguration.Builder getShutdown() {
            return shutdown != null ? shutdown.toBuilder() : null;
        }

        @Override
        public final Builder shutdown(ShutdownEventConfiguration shutdown) {
            this.shutdown = shutdown;
            return this;
        }

        public final void setShutdown(ShutdownEventConfiguration.BuilderImpl shutdown) {
            this.shutdown = shutdown != null ? shutdown.build() : null;
        }

        @Override
        public LifecycleEventConfiguration build() {
            return new LifecycleEventConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
