/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeploymentCommandName {
    INSTALL_DEPENDENCIES("install_dependencies"),
    UPDATE_DEPENDENCIES("update_dependencies"),
    UPDATE_CUSTOM_COOKBOOKS("update_custom_cookbooks"),
    EXECUTE_RECIPES("execute_recipes"),
    CONFIGURE("configure"),
    SETUP("setup"),
    DEPLOY("deploy"),
    ROLLBACK("rollback"),
    START("start"),
    STOP("stop"),
    RESTART("restart"),
    UNDEPLOY("undeploy"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeploymentCommandName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentCommandName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeploymentCommandName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentCommandName> knownValues() {
        return Stream.of(DeploymentCommandName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

