/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StackConfigurationManager;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAgentVersionsRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeAgentVersionsRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeAgentVersionsRequest.getter(DescribeAgentVersionsRequest::stackId)).setter(DescribeAgentVersionsRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<StackConfigurationManager> CONFIGURATION_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeAgentVersionsRequest.getter(DescribeAgentVersionsRequest::configurationManager)).setter(DescribeAgentVersionsRequest.setter(Builder::configurationManager)).constructor(StackConfigurationManager::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationManager").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, CONFIGURATION_MANAGER_FIELD));
    private final String stackId;
    private final StackConfigurationManager configurationManager;

    private DescribeAgentVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.configurationManager = builder.configurationManager;
    }

    public String stackId() {
        return this.stackId;
    }

    public StackConfigurationManager configurationManager() {
        return this.configurationManager;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationManager());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentVersionsRequest)) {
            return false;
        }
        DescribeAgentVersionsRequest other = (DescribeAgentVersionsRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.configurationManager(), other.configurationManager());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAgentVersionsRequest").add("StackId", (Object)this.stackId()).add("ConfigurationManager", (Object)this.configurationManager()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "ConfigurationManager": {
                return Optional.ofNullable(clazz.cast(this.configurationManager()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentVersionsRequest, T> g) {
        return obj -> g.apply((DescribeAgentVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private StackConfigurationManager configurationManager;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentVersionsRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.configurationManager(model.configurationManager);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return this.configurationManager != null ? this.configurationManager.toBuilder() : null;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAgentVersionsRequest build() {
            return new DescribeAgentVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAgentVersionsRequest> {
        public Builder stackId(String var1);

        public Builder configurationManager(StackConfigurationManager var1);

        default public Builder configurationManager(Consumer<StackConfigurationManager.Builder> configurationManager) {
            return this.configurationManager((StackConfigurationManager)((StackConfigurationManager.Builder)StackConfigurationManager.builder().applyMutation(configurationManager)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

