/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeploymentsRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeDeploymentsRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDeploymentsRequest.getter(DescribeDeploymentsRequest::stackId)).setter(DescribeDeploymentsRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDeploymentsRequest.getter(DescribeDeploymentsRequest::appId)).setter(DescribeDeploymentsRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppId").build()}).build();
    private static final SdkField<List<String>> DEPLOYMENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDeploymentsRequest.getter(DescribeDeploymentsRequest::deploymentIds)).setter(DescribeDeploymentsRequest.setter(Builder::deploymentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, APP_ID_FIELD, DEPLOYMENT_IDS_FIELD));
    private final String stackId;
    private final String appId;
    private final List<String> deploymentIds;

    private DescribeDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.deploymentIds = builder.deploymentIds;
    }

    public String stackId() {
        return this.stackId;
    }

    public String appId() {
        return this.appId;
    }

    public boolean hasDeploymentIds() {
        return this.deploymentIds != null && !(this.deploymentIds instanceof SdkAutoConstructList);
    }

    public List<String> deploymentIds() {
        return this.deploymentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentsRequest)) {
            return false;
        }
        DescribeDeploymentsRequest other = (DescribeDeploymentsRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.deploymentIds(), other.deploymentIds());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDeploymentsRequest").add("StackId", (Object)this.stackId()).add("AppId", (Object)this.appId()).add("DeploymentIds", this.deploymentIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "DeploymentIds": {
                return Optional.ofNullable(clazz.cast(this.deploymentIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeploymentsRequest, T> g) {
        return obj -> g.apply((DescribeDeploymentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String appId;
        private List<String> deploymentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentsRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.appId(model.appId);
            this.deploymentIds(model.deploymentIds);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final Collection<String> getDeploymentIds() {
            return this.deploymentIds;
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = StringsCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String ... deploymentIds) {
            this.deploymentIds(Arrays.asList(deploymentIds));
            return this;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = StringsCopier.copy(deploymentIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeploymentsRequest build() {
            return new DescribeDeploymentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeploymentsRequest> {
        public Builder stackId(String var1);

        public Builder appId(String var1);

        public Builder deploymentIds(Collection<String> var1);

        public Builder deploymentIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

