/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.MetricKeyDataPoints;
import software.amazon.awssdk.services.pi.model.MetricKeyDataPointsListCopier;
import software.amazon.awssdk.services.pi.model.PiResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceMetricsResponse
extends PiResponse
implements ToCopyableBuilder<Builder, GetResourceMetricsResponse> {
    private static final SdkField<Instant> ALIGNED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AlignedStartTime").getter(GetResourceMetricsResponse.getter(GetResourceMetricsResponse::alignedStartTime)).setter(GetResourceMetricsResponse.setter(Builder::alignedStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlignedStartTime").build()}).build();
    private static final SdkField<Instant> ALIGNED_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AlignedEndTime").getter(GetResourceMetricsResponse.getter(GetResourceMetricsResponse::alignedEndTime)).setter(GetResourceMetricsResponse.setter(Builder::alignedEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlignedEndTime").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(GetResourceMetricsResponse.getter(GetResourceMetricsResponse::identifier)).setter(GetResourceMetricsResponse.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<List<MetricKeyDataPoints>> METRIC_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricList").getter(GetResourceMetricsResponse.getter(GetResourceMetricsResponse::metricList)).setter(GetResourceMetricsResponse.setter(Builder::metricList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricKeyDataPoints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetResourceMetricsResponse.getter(GetResourceMetricsResponse::nextToken)).setter(GetResourceMetricsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNED_START_TIME_FIELD, ALIGNED_END_TIME_FIELD, IDENTIFIER_FIELD, METRIC_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final Instant alignedStartTime;
    private final Instant alignedEndTime;
    private final String identifier;
    private final List<MetricKeyDataPoints> metricList;
    private final String nextToken;

    private GetResourceMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.alignedStartTime = builder.alignedStartTime;
        this.alignedEndTime = builder.alignedEndTime;
        this.identifier = builder.identifier;
        this.metricList = builder.metricList;
        this.nextToken = builder.nextToken;
    }

    public Instant alignedStartTime() {
        return this.alignedStartTime;
    }

    public Instant alignedEndTime() {
        return this.alignedEndTime;
    }

    public String identifier() {
        return this.identifier;
    }

    public boolean hasMetricList() {
        return this.metricList != null && !(this.metricList instanceof SdkAutoConstructList);
    }

    public List<MetricKeyDataPoints> metricList() {
        return this.metricList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alignedStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.alignedEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricList() ? this.metricList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceMetricsResponse)) {
            return false;
        }
        GetResourceMetricsResponse other = (GetResourceMetricsResponse)((Object)obj);
        return Objects.equals(this.alignedStartTime(), other.alignedStartTime()) && Objects.equals(this.alignedEndTime(), other.alignedEndTime()) && Objects.equals(this.identifier(), other.identifier()) && this.hasMetricList() == other.hasMetricList() && Objects.equals(this.metricList(), other.metricList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetResourceMetricsResponse").add("AlignedStartTime", (Object)this.alignedStartTime()).add("AlignedEndTime", (Object)this.alignedEndTime()).add("Identifier", (Object)this.identifier()).add("MetricList", this.hasMetricList() ? this.metricList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlignedStartTime": {
                return Optional.ofNullable(clazz.cast(this.alignedStartTime()));
            }
            case "AlignedEndTime": {
                return Optional.ofNullable(clazz.cast(this.alignedEndTime()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "MetricList": {
                return Optional.ofNullable(clazz.cast(this.metricList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceMetricsResponse, T> g) {
        return obj -> g.apply((GetResourceMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiResponse.BuilderImpl
    implements Builder {
        private Instant alignedStartTime;
        private Instant alignedEndTime;
        private String identifier;
        private List<MetricKeyDataPoints> metricList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceMetricsResponse model) {
            super(model);
            this.alignedStartTime(model.alignedStartTime);
            this.alignedEndTime(model.alignedEndTime);
            this.identifier(model.identifier);
            this.metricList(model.metricList);
            this.nextToken(model.nextToken);
        }

        public final Instant getAlignedStartTime() {
            return this.alignedStartTime;
        }

        @Override
        public final Builder alignedStartTime(Instant alignedStartTime) {
            this.alignedStartTime = alignedStartTime;
            return this;
        }

        public final void setAlignedStartTime(Instant alignedStartTime) {
            this.alignedStartTime = alignedStartTime;
        }

        public final Instant getAlignedEndTime() {
            return this.alignedEndTime;
        }

        @Override
        public final Builder alignedEndTime(Instant alignedEndTime) {
            this.alignedEndTime = alignedEndTime;
            return this;
        }

        public final void setAlignedEndTime(Instant alignedEndTime) {
            this.alignedEndTime = alignedEndTime;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final Collection<MetricKeyDataPoints.Builder> getMetricList() {
            if (this.metricList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricList != null ? (Collection)this.metricList.stream().map(MetricKeyDataPoints::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricList(Collection<MetricKeyDataPoints> metricList) {
            this.metricList = MetricKeyDataPointsListCopier.copy(metricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(MetricKeyDataPoints ... metricList) {
            this.metricList(Arrays.asList(metricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Consumer<MetricKeyDataPoints.Builder> ... metricList) {
            this.metricList(Stream.of(metricList).map(c -> (MetricKeyDataPoints)((MetricKeyDataPoints.Builder)MetricKeyDataPoints.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricList(Collection<MetricKeyDataPoints.BuilderImpl> metricList) {
            this.metricList = MetricKeyDataPointsListCopier.copyFromBuilder(metricList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetResourceMetricsResponse build() {
            return new GetResourceMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceMetricsResponse> {
        public Builder alignedStartTime(Instant var1);

        public Builder alignedEndTime(Instant var1);

        public Builder identifier(String var1);

        public Builder metricList(Collection<MetricKeyDataPoints> var1);

        public Builder metricList(MetricKeyDataPoints ... var1);

        public Builder metricList(Consumer<MetricKeyDataPoints.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

