/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataSourceRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateDataSourceRequest.Builder, UpdateDataSourceRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSourceRequest::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSourceRequest::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSourceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DataSourceParameters> DATA_SOURCE_PARAMETERS_FIELD = SdkField
            .<DataSourceParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDataSourceRequest::dataSourceParameters)).setter(setter(Builder::dataSourceParameters))
            .constructor(DataSourceParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceParameters").build())
            .build();

    private static final SdkField<DataSourceCredentials> CREDENTIALS_FIELD = SdkField
            .<DataSourceCredentials> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDataSourceRequest::credentials))
            .setter(setter(Builder::credentials)).constructor(DataSourceCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final SdkField<VpcConnectionProperties> VPC_CONNECTION_PROPERTIES_FIELD = SdkField
            .<VpcConnectionProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateDataSourceRequest::vpcConnectionProperties)).setter(setter(Builder::vpcConnectionProperties))
            .constructor(VpcConnectionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionProperties").build())
            .build();

    private static final SdkField<SslProperties> SSL_PROPERTIES_FIELD = SdkField
            .<SslProperties> builder(MarshallingType.SDK_POJO).getter(getter(UpdateDataSourceRequest::sslProperties))
            .setter(setter(Builder::sslProperties)).constructor(SslProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DATA_SOURCE_ID_FIELD, NAME_FIELD, DATA_SOURCE_PARAMETERS_FIELD, CREDENTIALS_FIELD, VPC_CONNECTION_PROPERTIES_FIELD,
            SSL_PROPERTIES_FIELD));

    private final String awsAccountId;

    private final String dataSourceId;

    private final String name;

    private final DataSourceParameters dataSourceParameters;

    private final DataSourceCredentials credentials;

    private final VpcConnectionProperties vpcConnectionProperties;

    private final SslProperties sslProperties;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSourceId = builder.dataSourceId;
        this.name = builder.name;
        this.dataSourceParameters = builder.dataSourceParameters;
        this.credentials = builder.credentials;
        this.vpcConnectionProperties = builder.vpcConnectionProperties;
        this.sslProperties = builder.sslProperties;
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the data source. This ID is unique per AWS Region for each AWS account.
     * </p>
     * 
     * @return The ID of the data source. This ID is unique per AWS Region for each AWS account.
     */
    public String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * A display name for the data source.
     * </p>
     * 
     * @return A display name for the data source.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The parameters that QuickSight uses to connect to your underlying source.
     * </p>
     * 
     * @return The parameters that QuickSight uses to connect to your underlying source.
     */
    public DataSourceParameters dataSourceParameters() {
        return dataSourceParameters;
    }

    /**
     * <p>
     * The credentials that QuickSight that uses to connect to your underlying source. Currently, only credentials based
     * on user name and password are supported.
     * </p>
     * 
     * @return The credentials that QuickSight that uses to connect to your underlying source. Currently, only
     *         credentials based on user name and password are supported.
     */
    public DataSourceCredentials credentials() {
        return credentials;
    }

    /**
     * <p>
     * Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying
     * source.
     * </p>
     * 
     * @return Use this parameter only when you want QuickSight to use a VPC connection when connecting to your
     *         underlying source.
     */
    public VpcConnectionProperties vpcConnectionProperties() {
        return vpcConnectionProperties;
    }

    /**
     * <p>
     * Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.
     * </p>
     * 
     * @return Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.
     */
    public SslProperties sslProperties() {
        return sslProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sslProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(name(), other.name()) && Objects.equals(dataSourceParameters(), other.dataSourceParameters())
                && Objects.equals(credentials(), other.credentials())
                && Objects.equals(vpcConnectionProperties(), other.vpcConnectionProperties())
                && Objects.equals(sslProperties(), other.sslProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDataSourceRequest").add("AwsAccountId", awsAccountId())
                .add("DataSourceId", dataSourceId()).add("Name", name()).add("DataSourceParameters", dataSourceParameters())
                .add("Credentials", credentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VpcConnectionProperties", vpcConnectionProperties()).add("SslProperties", sslProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DataSourceParameters":
            return Optional.ofNullable(clazz.cast(dataSourceParameters()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "VpcConnectionProperties":
            return Optional.ofNullable(clazz.cast(vpcConnectionProperties()));
        case "SslProperties":
            return Optional.ofNullable(clazz.cast(sslProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataSourceRequest> {
        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the data source. This ID is unique per AWS Region for each AWS account.
         * </p>
         * 
         * @param dataSourceId
         *        The ID of the data source. This ID is unique per AWS Region for each AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A display name for the data source.
         * </p>
         * 
         * @param name
         *        A display name for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The parameters that QuickSight uses to connect to your underlying source.
         * </p>
         * 
         * @param dataSourceParameters
         *        The parameters that QuickSight uses to connect to your underlying source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceParameters(DataSourceParameters dataSourceParameters);

        /**
         * <p>
         * The parameters that QuickSight uses to connect to your underlying source.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSourceParameters.Builder} avoiding the need
         * to create one manually via {@link DataSourceParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSourceParameters(DataSourceParameters)}.
         * 
         * @param dataSourceParameters
         *        a consumer that will call methods on {@link DataSourceParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceParameters(DataSourceParameters)
         */
        default Builder dataSourceParameters(Consumer<DataSourceParameters.Builder> dataSourceParameters) {
            return dataSourceParameters(DataSourceParameters.builder().applyMutation(dataSourceParameters).build());
        }

        /**
         * <p>
         * The credentials that QuickSight that uses to connect to your underlying source. Currently, only credentials
         * based on user name and password are supported.
         * </p>
         * 
         * @param credentials
         *        The credentials that QuickSight that uses to connect to your underlying source. Currently, only
         *        credentials based on user name and password are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(DataSourceCredentials credentials);

        /**
         * <p>
         * The credentials that QuickSight that uses to connect to your underlying source. Currently, only credentials
         * based on user name and password are supported.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSourceCredentials.Builder} avoiding the need
         * to create one manually via {@link DataSourceCredentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #credentials(DataSourceCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link DataSourceCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(DataSourceCredentials)
         */
        default Builder credentials(Consumer<DataSourceCredentials.Builder> credentials) {
            return credentials(DataSourceCredentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying
         * source.
         * </p>
         * 
         * @param vpcConnectionProperties
         *        Use this parameter only when you want QuickSight to use a VPC connection when connecting to your
         *        underlying source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties);

        /**
         * <p>
         * Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying
         * source.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConnectionProperties.Builder} avoiding the
         * need to create one manually via {@link VpcConnectionProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConnectionProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConnectionProperties(VpcConnectionProperties)}.
         * 
         * @param vpcConnectionProperties
         *        a consumer that will call methods on {@link VpcConnectionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConnectionProperties(VpcConnectionProperties)
         */
        default Builder vpcConnectionProperties(Consumer<VpcConnectionProperties.Builder> vpcConnectionProperties) {
            return vpcConnectionProperties(VpcConnectionProperties.builder().applyMutation(vpcConnectionProperties).build());
        }

        /**
         * <p>
         * Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.
         * </p>
         * 
         * @param sslProperties
         *        Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslProperties(SslProperties sslProperties);

        /**
         * <p>
         * Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.
         * </p>
         * This is a convenience that creates an instance of the {@link SslProperties.Builder} avoiding the need to
         * create one manually via {@link SslProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SslProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #sslProperties(SslProperties)}.
         * 
         * @param sslProperties
         *        a consumer that will call methods on {@link SslProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sslProperties(SslProperties)
         */
        default Builder sslProperties(Consumer<SslProperties.Builder> sslProperties) {
            return sslProperties(SslProperties.builder().applyMutation(sslProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dataSourceId;

        private String name;

        private DataSourceParameters dataSourceParameters;

        private DataSourceCredentials credentials;

        private VpcConnectionProperties vpcConnectionProperties;

        private SslProperties sslProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dataSourceId(model.dataSourceId);
            name(model.name);
            dataSourceParameters(model.dataSourceParameters);
            credentials(model.credentials);
            vpcConnectionProperties(model.vpcConnectionProperties);
            sslProperties(model.sslProperties);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final DataSourceParameters.Builder getDataSourceParameters() {
            return dataSourceParameters != null ? dataSourceParameters.toBuilder() : null;
        }

        @Override
        public final Builder dataSourceParameters(DataSourceParameters dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters;
            return this;
        }

        public final void setDataSourceParameters(DataSourceParameters.BuilderImpl dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters != null ? dataSourceParameters.build() : null;
        }

        public final DataSourceCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(DataSourceCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(DataSourceCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final VpcConnectionProperties.Builder getVpcConnectionProperties() {
            return vpcConnectionProperties != null ? vpcConnectionProperties.toBuilder() : null;
        }

        @Override
        public final Builder vpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties;
            return this;
        }

        public final void setVpcConnectionProperties(VpcConnectionProperties.BuilderImpl vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties != null ? vpcConnectionProperties.build() : null;
        }

        public final SslProperties.Builder getSslProperties() {
            return sslProperties != null ? sslProperties.toBuilder() : null;
        }

        @Override
        public final Builder sslProperties(SslProperties sslProperties) {
            this.sslProperties = sslProperties;
            return this;
        }

        public final void setSslProperties(SslProperties.BuilderImpl sslProperties) {
            this.sslProperties = sslProperties != null ? sslProperties.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
