/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPermissionsResponse extends RamResponse implements
        ToCopyableBuilder<ListPermissionsResponse.Builder, ListPermissionsResponse> {
    private static final SdkField<List<ResourceSharePermissionSummary>> PERMISSIONS_FIELD = SdkField
            .<List<ResourceSharePermissionSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListPermissionsResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceSharePermissionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceSharePermissionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPermissionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ResourceSharePermissionSummary> permissions;

    private final String nextToken;

    private ListPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.permissions = builder.permissions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Permissions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the permissions.
     */
    public List<ResourceSharePermissionSummary> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionsResponse)) {
            return false;
        }
        ListPermissionsResponse other = (ListPermissionsResponse) obj;
        return Objects.equals(permissions(), other.permissions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPermissionsResponse").add("Permissions", permissions()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionsResponse, T> g) {
        return obj -> g.apply((ListPermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPermissionsResponse> {
        /**
         * <p>
         * Information about the permissions.
         * </p>
         * 
         * @param permissions
         *        Information about the permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourceSharePermissionSummary> permissions);

        /**
         * <p>
         * Information about the permissions.
         * </p>
         * 
         * @param permissions
         *        Information about the permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourceSharePermissionSummary... permissions);

        /**
         * <p>
         * Information about the permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceSharePermissionSummary>.Builder}
         * avoiding the need to create one manually via {@link List<ResourceSharePermissionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceSharePermissionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #permissions(List<ResourceSharePermissionSummary>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<ResourceSharePermissionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<ResourceSharePermissionSummary>)
         */
        Builder permissions(Consumer<ResourceSharePermissionSummary.Builder>... permissions);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RamResponse.BuilderImpl implements Builder {
        private List<ResourceSharePermissionSummary> permissions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionsResponse model) {
            super(model);
            permissions(model.permissions);
            nextToken(model.nextToken);
        }

        public final Collection<ResourceSharePermissionSummary.Builder> getPermissions() {
            return permissions != null ? permissions.stream().map(ResourceSharePermissionSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder permissions(Collection<ResourceSharePermissionSummary> permissions) {
            this.permissions = ResourceSharePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourceSharePermissionSummary... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourceSharePermissionSummary.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourceSharePermissionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<ResourceSharePermissionSummary.BuilderImpl> permissions) {
            this.permissions = ResourceSharePermissionListCopier.copyFromBuilder(permissions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPermissionsResponse build() {
            return new ListPermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
