/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplacePermissionAssociationsRequest extends RamRequest implements
        ToCopyableBuilder<ReplacePermissionAssociationsRequest.Builder, ReplacePermissionAssociationsRequest> {
    private static final SdkField<String> FROM_PERMISSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromPermissionArn").getter(getter(ReplacePermissionAssociationsRequest::fromPermissionArn))
            .setter(setter(Builder::fromPermissionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromPermissionArn").build()).build();

    private static final SdkField<Integer> FROM_PERMISSION_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("fromPermissionVersion").getter(getter(ReplacePermissionAssociationsRequest::fromPermissionVersion))
            .setter(setter(Builder::fromPermissionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromPermissionVersion").build())
            .build();

    private static final SdkField<String> TO_PERMISSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("toPermissionArn").getter(getter(ReplacePermissionAssociationsRequest::toPermissionArn))
            .setter(setter(Builder::toPermissionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toPermissionArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(ReplacePermissionAssociationsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PERMISSION_ARN_FIELD,
            FROM_PERMISSION_VERSION_FIELD, TO_PERMISSION_ARN_FIELD, CLIENT_TOKEN_FIELD));

    private final String fromPermissionArn;

    private final Integer fromPermissionVersion;

    private final String toPermissionArn;

    private final String clientToken;

    private ReplacePermissionAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.fromPermissionArn = builder.fromPermissionArn;
        this.fromPermissionVersion = builder.fromPermissionVersion;
        this.toPermissionArn = builder.toPermissionArn;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Name (ARN)</a> of the managed permission that you want to replace.
     * </p>
     * 
     * @return Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Name (ARN)</a> of the managed permission that you want to replace.
     */
    public final String fromPermissionArn() {
        return fromPermissionArn;
    }

    /**
     * <p>
     * Specifies that you want to updated the permissions for only those resource shares that use the specified version
     * of the managed permission.
     * </p>
     * 
     * @return Specifies that you want to updated the permissions for only those resource shares that use the specified
     *         version of the managed permission.
     */
    public final Integer fromPermissionVersion() {
        return fromPermissionVersion;
    }

    /**
     * <p>
     * Specifies the ARN of the managed permission that you want to associate with resource shares in place of the one
     * specified by <code>fromPerssionArn</code> and <code>fromPermissionVersion</code>.
     * </p>
     * <p>
     * The operation always associates the version that is currently the default for the specified managed permission.
     * </p>
     * 
     * @return Specifies the ARN of the managed permission that you want to associate with resource shares in place of
     *         the one specified by <code>fromPerssionArn</code> and <code>fromPermissionVersion</code>.</p>
     *         <p>
     *         The operation always associates the version that is currently the default for the specified managed
     *         permission.
     */
    public final String toPermissionArn() {
        return toPermissionArn;
    }

    /**
     * <p>
     * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
     * lets you safely retry the request without accidentally performing the same operation a second time. Passing the
     * same value to a later call to an operation requires that you also pass the same value for all other parameters.
     * We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of
     * value.</a>.
     * </p>
     * <p>
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     * </p>
     * <p>
     * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails
     * with an <code>IdempotentParameterMismatch</code> error.
     * </p>
     * 
     * @return Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         This lets you safely retry the request without accidentally performing the same operation a second time.
     *         Passing the same value to a later call to an operation requires that you also pass the same value for all
     *         other parameters. We recommend that you use a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
     *         <p>
     *         If you don't provide this value, then Amazon Web Services generates a random one for you.
     *         </p>
     *         <p>
     *         If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
     *         retry fails with an <code>IdempotentParameterMismatch</code> error.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fromPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(fromPermissionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(toPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplacePermissionAssociationsRequest)) {
            return false;
        }
        ReplacePermissionAssociationsRequest other = (ReplacePermissionAssociationsRequest) obj;
        return Objects.equals(fromPermissionArn(), other.fromPermissionArn())
                && Objects.equals(fromPermissionVersion(), other.fromPermissionVersion())
                && Objects.equals(toPermissionArn(), other.toPermissionArn())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplacePermissionAssociationsRequest").add("FromPermissionArn", fromPermissionArn())
                .add("FromPermissionVersion", fromPermissionVersion()).add("ToPermissionArn", toPermissionArn())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fromPermissionArn":
            return Optional.ofNullable(clazz.cast(fromPermissionArn()));
        case "fromPermissionVersion":
            return Optional.ofNullable(clazz.cast(fromPermissionVersion()));
        case "toPermissionArn":
            return Optional.ofNullable(clazz.cast(toPermissionArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplacePermissionAssociationsRequest, T> g) {
        return obj -> g.apply((ReplacePermissionAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RamRequest.Builder, SdkPojo, CopyableBuilder<Builder, ReplacePermissionAssociationsRequest> {
        /**
         * <p>
         * Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Name (ARN)</a> of the managed permission that you want to replace.
         * </p>
         * 
         * @param fromPermissionArn
         *        Specifies the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of the managed permission that you want to replace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPermissionArn(String fromPermissionArn);

        /**
         * <p>
         * Specifies that you want to updated the permissions for only those resource shares that use the specified
         * version of the managed permission.
         * </p>
         * 
         * @param fromPermissionVersion
         *        Specifies that you want to updated the permissions for only those resource shares that use the
         *        specified version of the managed permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPermissionVersion(Integer fromPermissionVersion);

        /**
         * <p>
         * Specifies the ARN of the managed permission that you want to associate with resource shares in place of the
         * one specified by <code>fromPerssionArn</code> and <code>fromPermissionVersion</code>.
         * </p>
         * <p>
         * The operation always associates the version that is currently the default for the specified managed
         * permission.
         * </p>
         * 
         * @param toPermissionArn
         *        Specifies the ARN of the managed permission that you want to associate with resource shares in place
         *        of the one specified by <code>fromPerssionArn</code> and <code>fromPermissionVersion</code>.</p>
         *        <p>
         *        The operation always associates the version that is currently the default for the specified managed
         *        permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPermissionArn(String toPermissionArn);

        /**
         * <p>
         * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
         * lets you safely retry the request without accidentally performing the same operation a second time. Passing
         * the same value to a later call to an operation requires that you also pass the same value for all other
         * parameters. We recommend that you use a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
         * </p>
         * <p>
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         * </p>
         * <p>
         * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry
         * fails with an <code>IdempotentParameterMismatch</code> error.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the
         *        request. This lets you safely retry the request without accidentally performing the same operation a
         *        second time. Passing the same value to a later call to an operation requires that you also pass the
         *        same value for all other parameters. We recommend that you use a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
         *        <p>
         *        If you don't provide this value, then Amazon Web Services generates a random one for you.
         *        </p>
         *        <p>
         *        If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
         *        retry fails with an <code>IdempotentParameterMismatch</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RamRequest.BuilderImpl implements Builder {
        private String fromPermissionArn;

        private Integer fromPermissionVersion;

        private String toPermissionArn;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplacePermissionAssociationsRequest model) {
            super(model);
            fromPermissionArn(model.fromPermissionArn);
            fromPermissionVersion(model.fromPermissionVersion);
            toPermissionArn(model.toPermissionArn);
            clientToken(model.clientToken);
        }

        public final String getFromPermissionArn() {
            return fromPermissionArn;
        }

        public final void setFromPermissionArn(String fromPermissionArn) {
            this.fromPermissionArn = fromPermissionArn;
        }

        @Override
        public final Builder fromPermissionArn(String fromPermissionArn) {
            this.fromPermissionArn = fromPermissionArn;
            return this;
        }

        public final Integer getFromPermissionVersion() {
            return fromPermissionVersion;
        }

        public final void setFromPermissionVersion(Integer fromPermissionVersion) {
            this.fromPermissionVersion = fromPermissionVersion;
        }

        @Override
        public final Builder fromPermissionVersion(Integer fromPermissionVersion) {
            this.fromPermissionVersion = fromPermissionVersion;
            return this;
        }

        public final String getToPermissionArn() {
            return toPermissionArn;
        }

        public final void setToPermissionArn(String toPermissionArn) {
            this.toPermissionArn = toPermissionArn;
        }

        @Override
        public final Builder toPermissionArn(String toPermissionArn) {
            this.toPermissionArn = toPermissionArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReplacePermissionAssociationsRequest build() {
            return new ReplacePermissionAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
