/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rdsdata.model.RdsDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommitTransactionRequest
extends RdsDataRequest
implements ToCopyableBuilder<Builder, CommitTransactionRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(CommitTransactionRequest.getter(CommitTransactionRequest::resourceArn)).setter(CommitTransactionRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretArn").getter(CommitTransactionRequest.getter(CommitTransactionRequest::secretArn)).setter(CommitTransactionRequest.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionId").getter(CommitTransactionRequest.getter(CommitTransactionRequest::transactionId)).setter(CommitTransactionRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, SECRET_ARN_FIELD, TRANSACTION_ID_FIELD));
    private final String resourceArn;
    private final String secretArn;
    private final String transactionId;

    private CommitTransactionRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.secretArn = builder.secretArn;
        this.transactionId = builder.transactionId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public String secretArn() {
        return this.secretArn;
    }

    public String transactionId() {
        return this.transactionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitTransactionRequest)) {
            return false;
        }
        CommitTransactionRequest other = (CommitTransactionRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.transactionId(), other.transactionId());
    }

    public String toString() {
        return ToString.builder((String)"CommitTransactionRequest").add("ResourceArn", (Object)this.resourceArn()).add("SecretArn", (Object)this.secretArn()).add("TransactionId", (Object)this.transactionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "secretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "transactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommitTransactionRequest, T> g) {
        return obj -> g.apply((CommitTransactionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsDataRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String secretArn;
        private String transactionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitTransactionRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.secretArn(model.secretArn);
            this.transactionId(model.transactionId);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CommitTransactionRequest build() {
            return new CommitTransactionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CommitTransactionRequest> {
        public Builder resourceArn(String var1);

        public Builder secretArn(String var1);

        public Builder transactionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

